
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
potassium = m.addVar(lb=0, name="potassium")
zinc = m.addVar(lb=0, name="zinc")
vitamin_b3 = m.addVar(lb=0, name="vitamin_b3")
magnesium = m.addVar(lb=0, name="magnesium")
carbohydrates = m.addVar(lb=0, name="carbohydrates")
protein = m.addVar(lb=0, name="protein")

# Set objective function
m.setObjective(3.99 * potassium**2 + 7.07 * zinc**2 + 4.89 * vitamin_b3 * protein + 5.06 * magnesium**2 + 7.64 * magnesium * carbohydrates + 3.65 * carbohydrates * protein + 9.06 * protein, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(19 * carbohydrates + 22 * protein >= 59)
m.addConstr(15 * potassium + 22 * protein >= 98)
m.addConstr(15 * potassium + 29 * zinc + 29 * vitamin_b3 + 10 * magnesium + 19 * carbohydrates + 22 * protein >= 98)
m.addConstr(-zinc + 9 * carbohydrates >= 0)
m.addConstr(6 * potassium - protein >= 0)
m.addConstr(3 * potassium - 10 * magnesium >= 0)
m.addConstr(-9 * potassium + 4 * zinc + 10 * magnesium >= 0)
m.addConstr(29 * zinc + 10 * magnesium <= 161)
m.addConstr(29 * zinc + 19 * carbohydrates <= 654)
m.addConstr(15 * potassium**2 + 22 * protein**2 <= 220)  # Note: Squared indices
m.addConstr(29 * vitamin_b3 + 19 * carbohydrates <= 158)
m.addConstr(15 * potassium + 29 * zinc <= 141)
m.addConstr(29 * vitamin_b3 + 10 * magnesium + 22 * protein <= 244)
m.addConstr(15 * potassium + 29 * zinc + 22 * protein <= 467)
m.addConstr(15 * potassium**2 + 29 * vitamin_b3**2 + 22 * protein**2 <= 298) # Note: Squared indices
m.addConstr(29 * zinc + 29 * vitamin_b3 + 22 * protein <= 579)
m.addConstr(15 * potassium**2 + 29 * vitamin_b3**2 + 10 * magnesium**2 <= 488) # Note: Squared indices
m.addConstr(29 * zinc + 19 * carbohydrates + 22 * protein <= 482)
m.addConstr(29 * zinc**2 + 10 * magnesium**2 + 19 * carbohydrates**2 <= 345) # Note: Squared indices
m.addConstr(29 * vitamin_b3**2 + 10 * magnesium**2 + 19 * carbohydrates**2 <= 455) # Note: Squared indices
m.addConstr(15 * potassium + 29 * vitamin_b3 + 19 * carbohydrates <= 183)
m.addConstr(29 * zinc + 29 * vitamin_b3 + 10 * magnesium <= 352)
m.addConstr(15 * potassium + 10 * magnesium + 19 * carbohydrates <= 476)
m.addConstr(29 * zinc + 29 * vitamin_b3 + 19 * carbohydrates <= 347)
m.addConstr(15 * potassium + 29 * zinc + 29 * vitamin_b3 + 10 * magnesium + 19 * carbohydrates + 22 * protein <= 731)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

