
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams of potassium")
x1 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams of zinc")
x2 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams of vitamin B3")
x3 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams of magnesium")
x4 = m.addVar(lb=-gp.GRB.INFINITY, name="grams of carbohydrates")
x5 = m.addVar(lb=-gp.GRB.INFINITY, name="grams of protein")

# Define the objective function
m.setObjective(3.99*x0**2 + 7.07*x1**2 + 4.89*x2*x5 + 5.06*x3**2 + 7.64*x3*x4 + 3.65*x4*x5 + 9.06*x5, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(15*x0 + 29*x1 + 29*x2 + 10*x3 + 19*x4 + 22*x5 >= 98)
m.addConstr(15*x0 + 22*x5 >= 98)
m.addConstr(15*x0 + 29*x1 + 29*x2 + 10*x3 + 19*x4 + 22*x5 >= 98)
m.addConstr(-x1 + 9*x4 >= 0)
m.addConstr(6*x0 - x5 >= 0)
m.addConstr(3*x0 - 10*x3 >= 0)
m.addConstr(-9*x0 + 4*x1 + 10*x3 >= 0)
m.addConstr(29*x1 + 10*x3 <= 161)
m.addConstr(29*x1 + 19*x4 <= 654)
m.addConstr(15**2*x0**2 + 22**2*x5**2 <= 220)
m.addConstr(29*x2 + 19*x4 <= 158)
m.addConstr(15*x0 + 29*x1 <= 141)
m.addConstr(29*x2 + 10*x3 + 22*x5 <= 244)
m.addConstr(15*x0 + 29*x1 + 22*x5 <= 467)
m.addConstr(15**2*x0**2 + 29**2*x2**2 + 22**2*x5**2 <= 298)
m.addConstr(29*x1 + 29*x2 + 22*x5 <= 579)
m.addConstr(15**2*x0**2 + 29**2*x2**2 + 10**2*x3**2 <= 488)
m.addConstr(29*x1 + 19*x4 + 22*x5 <= 482)
m.addConstr(29**2*x1**2 + 10**2*x3**2 + 19**2*x4**2 <= 345)
m.addConstr(29**2*x2**2 + 10**2*x3**2 + 19**2*x4**2 <= 455)
m.addConstr(15*x0 + 29*x2 + 19*x4 <= 183)
m.addConstr(29*x1 + 29*x2 + 10*x3 <= 352)
m.addConstr(15*x0 + 10*x3 + 19*x4 <= 476)
m.addConstr(29*x1 + 29*x2 + 19*x4 <= 347)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Milligrams of potassium: ", x0.varValue)
    print("Milligrams of zinc: ", x1.varValue)
    print("Milligrams of vitamin B3: ", x2.varValue)
    print("Milligrams of magnesium: ", x3.varValue)
    print("Grams of carbohydrates: ", x4.varValue)
    print("Grams of protein: ", x5.varValue)
else:
    print("The model is infeasible")
