
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_breasts")
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="sashimi")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="chicken_drumsticks")
x3 = m.addVar(lb=0, vtype=GRB.INTEGER, name="hamburgers")

# Objective function
m.setObjective(1*x0 + 6*x1 + 3*x2 + 1*x3, GRB.MAXIMIZE)

# Constraints
m.addConstr(1.17*x0 + 1.79*x2 + 3.04*x3 >= 23)
m.addConstr(1.68*x1 + 1.79*x2 + 3.04*x3 >= 23)
m.addConstr(1.17*x0 + 1.68*x1 + 1.79*x2 >= 23)
m.addConstr(1.17*x0 + 1.79*x2 + 3.04*x3 >= 16)
m.addConstr(1.68*x1 + 1.79*x2 + 3.04*x3 >= 16)
m.addConstr(1.17*x0 + 1.68*x1 + 1.79*x2 >= 16)
m.addConstr(1.17*x0 + 1.79*x2 + 3.04*x3 >= 26)
m.addConstr(1.68*x1 + 1.79*x2 + 3.04*x3 >= 26)
m.addConstr(1.17*x0 + 1.68*x1 + 1.79*x2 >= 26)
m.addConstr(1.17*x0 + 1.68*x1 <= 34)
m.addConstr(1.79*x2 + 3.04*x3 <= 101)
m.addConstr(1.17*x0 + 3.04*x3 <= 122)
m.addConstr(1.68*x1 + 3.04*x3 <= 106)
m.addConstr(1.68*x1 + 1.79*x2 + 3.04*x3 <= 41)
m.addConstr(1.17*x0 + 1.79*x2 + 3.04*x3 <= 67)
m.addConstr(1.17*x0 + 1.68*x1 + 3.04*x3 <= 111)
m.addConstr(1.17*x0 + 1.68*x1 + 1.79*x2 + 3.04*x3 <= 111)

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print("%s = %g" % (v.varName, v.x))
else:
    print("No optimal solution found")
