
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="chicken_breasts", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=0, name="sashimi", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=0, name="chicken_drumsticks", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(lb=0, name="hamburgers", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(x0 + 6 * x1 + 3 * x2 + x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Minimum Healthiness Constraints
    model.addConstr(1.17 * x0 + 1.79 * x2 + 3.04 * x3 >= 23)
    model.addConstr(1.68 * x1 + 1.79 * x2 + 3.04 * x3 >= 23)
    model.addConstr(1.17 * x0 + 1.68 * x1 + 1.79 * x2 >= 23)

    # Alternative Minimum Healthiness Constraints
    model.addConstr(1.17 * x0 + 1.79 * x2 + 3.04 * x3 >= 16)
    model.addConstr(1.68 * x1 + 1.79 * x2 + 3.04 * x3 >= 16)
    model.addConstr(1.17 * x0 + 1.68 * x1 + 1.79 * x2 >= 16)

    # Higher Minimum Healthiness Constraints
    model.addConstr(1.17 * x0 + 1.79 * x2 + 3.04 * x3 >= 26)
    model.addConstr(1.68 * x1 + 1.79 * x2 + 3.04 * x3 >= 26)
    model.addConstr(1.17 * x0 + 1.68 * x1 + 1.79 * x2 >= 26)

    # Maximum Healthiness Constraints
    model.addConstr(1.17 * x0 + 1.68 * x1 <= 34)
    model.addConstr(1.79 * x2 + 3.04 * x3 <= 101)
    model.addConstr(1.17 * x0 + 3.04 * x3 <= 122)
    model.addConstr(1.68 * x1 + 3.04 * x3 <= 106)
    model.addConstr(1.68 * x1 + 1.79 * x2 + 3.04 * x3 <= 41)
    model.addConstr(1.17 * x0 + 1.79 * x2 + 3.04 * x3 <= 67)
    model.addConstr(1.17 * x0 + 1.68 * x1 + 3.04 * x3 <= 111)
    model.addConstr(1.17 * x0 + 1.68 * x1 + 1.79 * x2 + 3.04 * x3 <= 111)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Chicken Breasts: ", x0.varValue)
        print("Sashimi: ", x1.varValue)
        print("Chicken Drumsticks: ", x2.varValue)
        print("Hamburgers: ", x3.varValue)
    else:
        print("No optimal solution found")

optimization_problem()
