
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
ravioli = m.addVar(lb=0, name="ravioli")
apple_pies = m.addVar(lb=0, name="apple_pies")
ramen = m.addVar(lb=0, name="ramen")
pizza = m.addVar(lb=0, name="pizza")
kiwis = m.addVar(lb=0, name="kiwis")
fruit_salads = m.addVar(lb=0, name="fruit_salads")

# Set objective function
m.setObjective(3 * ravioli + 3 * apple_pies + 2 * ramen + pizza + 4 * kiwis + 5 * fruit_salads, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.01 * apple_pies + 0.16 * ramen >= 55)
m.addConstr(0.62 * ravioli + 0.16 * ramen >= 33)
m.addConstr(0.62 * ravioli + 0.79 * pizza >= 24)
m.addConstr(0.95 * kiwis + 0.66 * fruit_salads >= 27)
m.addConstr(0.79 * pizza + 0.95 * kiwis >= 18)
m.addConstr(0.79 * pizza + 0.66 * fruit_salads >= 37)
m.addConstr(0.16 * ramen + 0.79 * pizza >= 47)
m.addConstr(0.62 * ravioli + 0.66 * fruit_salads >= 35)
m.addConstr(0.16 * ramen + 0.66 * fruit_salads >= 26)
m.addConstr(0.62 * ravioli + 0.95 * kiwis >= 32)
m.addConstr(0.01 * apple_pies + 0.95 * kiwis >= 53)
m.addConstr(0.62 * ravioli + 0.01 * apple_pies + 0.79 * pizza >= 54)
m.addConstr(0.62 * ravioli + 0.79 * pizza + 0.66 * fruit_salads >= 54)
m.addConstr(0.01 * apple_pies + 0.16 * ramen + 0.79 * pizza >= 54)
m.addConstr(0.01 * apple_pies + 0.79 * pizza + 0.95 * kiwis >= 54)

m.addConstr(0.62 * ravioli + 0.16 * ramen <= 128)
m.addConstr(0.95 * kiwis + 0.66 * fruit_salads <= 94)
m.addConstr(0.01 * apple_pies + 0.16 * ramen <= 321)
m.addConstr(0.01 * apple_pies + 0.66 * fruit_salads <= 239)
m.addConstr(0.62 * ravioli + 0.01 * apple_pies <= 236)
m.addConstr(0.62 * ravioli + 0.95 * kiwis <= 150)
m.addConstr(0.16 * ramen + 0.79 * pizza <= 139)
m.addConstr(0.62 * ravioli + 0.79 * pizza <= 286)
m.addConstr(0.79 * pizza + 0.95 * kiwis + 0.66 * fruit_salads <= 245)
m.addConstr(0.62 * ravioli + 0.95 * kiwis + 0.66 * fruit_salads <= 142)
m.addConstr(0.62 * ravioli + 0.01 * apple_pies + 0.79 * pizza <= 178)
m.addConstr(0.16 * ramen + 0.79 * pizza + 0.66 * fruit_salads <= 175)
m.addConstr(0.16 * ramen + 0.95 * kiwis + 0.66 * fruit_salads <= 136)
m.addConstr(0.01 * apple_pies + 0.16 * ramen + 0.95 * kiwis <= 215)
m.addConstr(0.16 * ramen + 0.79 * pizza + 0.95 * kiwis <= 265)
m.addConstr(0.01 * apple_pies + 0.79 * pizza + 0.95 * kiwis <= 327)
m.addConstr(0.01 * apple_pies + 0.79 * pizza + 0.66 * fruit_salads <= 147)
m.addConstr(0.62 * ravioli + 0.16 * ramen + 0.79 * pizza <= 215)
m.addConstr(0.62 * ravioli + 0.16 * ramen + 0.66 * fruit_salads <= 87)
m.addConstr(0.62 * ravioli + 0.01 * apple_pies + 0.16 * ramen + 0.79 * pizza + 0.95 * kiwis + 0.66 * fruit_salads <= 87)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

