
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_allocation")

# Create variables
security_engineers = m.addVar(vtype=GRB.INTEGER, name="security_engineers")
patches_per_day = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")

# Set objective function
m.setObjective(9.0 * security_engineers + 2.1 * patches_per_day, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.63 * security_engineers + 3.53 * patches_per_day >= 16, "min_cost")
m.addConstr(2.84 * security_engineers + 1.26 * patches_per_day >= 36, "min_bandwidth")
m.addConstr(0.01 * security_engineers + 3.75 * patches_per_day >= 30, "min_integrity")
m.addConstr(-2 * security_engineers + 1 * patches_per_day >= 0, "custom_constraint")
m.addConstr(0.63 * security_engineers + 3.53 * patches_per_day <= 43, "max_cost")
m.addConstr(2.84 * security_engineers + 1.26 * patches_per_day <= 118, "max_bandwidth")
m.addConstr(0.01 * security_engineers + 3.75 * patches_per_day <= 105, "max_integrity")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Optimal solution found')
    print(f'Security Engineers: {security_engineers.x}')
    print(f'Patches per Day: {patches_per_day.x}')
    print(f'Objective Value: {m.objVal}')
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print(f'Optimization ended with status {m.status}')

