
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="security_engineers")
x1 = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")

# Objective function: Minimize 9.0*x0 + 2.1*x1
m.setObjective(9.0*x0 + 2.1*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(0.63*x0 + 3.53*x1 >= 16, "min_spend")
m.addConstr(0.63*x0 + 3.53*x1 <= 43, "max_spend")
m.addConstr(2.84*x0 + 1.26*x1 >= 36, "min_bandwidth")
m.addConstr(2.84*x0 + 1.26*x1 <= 118, "max_bandwidth")
m.addConstr(0.01*x0 + 3.75*x1 >= 30, "min_integrity")
m.addConstr(0.01*x0 + 3.75*x1 <= 105, "max_integrity")
m.addConstr(-2*x0 + x1 >= 0, "security_patches_relation")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Security Engineers:", x0.x)
    print("Patches per Day:", x1.x)
    print("Objective Function Value:", m.objVal)
else:
    print("No optimal solution found")
