
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
mary_hours = model.addVar(lb=0, name="mary_hours")
dale_hours = model.addVar(lb=0, name="dale_hours")
peggy_hours = model.addVar(lb=0, name="peggy_hours")

# Set objective function
model.setObjective(8 * mary_hours + 8 * dale_hours + 9 * peggy_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * mary_hours + 3 * dale_hours <= 114, "c1")  # Work quality: Mary + Dale
model.addConstr(3 * dale_hours + 4 * peggy_hours <= 57, "c2")  # Work quality: Dale + Peggy
model.addConstr(6 * mary_hours + 3 * dale_hours + 4 * peggy_hours <= 57, "c3")  # Work quality: Mary + Dale + Peggy

model.addConstr(13 * dale_hours + 4 * peggy_hours >= 37, "c4")  # Computer competence: Dale + Peggy
model.addConstr(2 * mary_hours + 4 * peggy_hours <= 85, "c5")  # Computer competence: Mary + Peggy
model.addConstr(13 * dale_hours + 4 * peggy_hours <= 121, "c6")  # Computer competence: Dale + Peggy
model.addConstr(2 * mary_hours + 13 * dale_hours + 4 * peggy_hours <= 88, "c7")  # Computer competence: Mary + Dale + Peggy


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: ', model.objVal)
    print('Mary Hours:', mary_hours.x)
    print('Dale Hours:', dale_hours.x)
    print('Peggy Hours:', peggy_hours.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

