
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    hours_mary = model.addVar(name="hours_worked_by_Mary", lb=0)
    hours_dale = model.addVar(name="hours_worked_by_Dale", lb=0)
    hours_peggy = model.addVar(name="hours_worked_by_Peggy", lb=0)

    # Objective function
    model.setObjective(8 * hours_mary + 8 * hours_dale + 9 * hours_peggy, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(hours_dale + hours_peggy >= 37, name="comp_comp_Dale_Peggy")
    model.addConstr(6 * hours_mary + 3 * hours_dale <= 114, name="work_qual_Mary_Dale")
    model.addConstr(3 * hours_dale + 4 * hours_peggy <= 57, name="work_qual_Dale_Peggy")
    model.addConstr(6 * hours_mary + 3 * hours_dale + 4 * hours_peggy <= 57, name="work_qual_Mary_Dale_Peggy")
    model.addConstr(2 * hours_mary + 4 * hours_peggy <= 85, name="comp_comp_Mary_Peggy")
    model.addConstr(13 * hours_dale + 4 * hours_peggy <= 121, name="comp_comp_Dale_Peggy")
    model.addConstr(2 * hours_mary + 13 * hours_dale + 4 * hours_peggy <= 88, name="comp_comp_Mary_Dale_Peggy")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Mary: ", hours_mary.varValue)
        print("Hours worked by Dale: ", hours_dale.varValue)
        print("Hours worked by Peggy: ", hours_peggy.varValue)
    else:
        print("No optimal solution found")

optimization_problem()
