
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    pizza = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pizza")
    pies = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pies")
    sandwiches = m.addVar(lb=0, vtype=GRB.INTEGER, name="sandwiches")
    bars = m.addVar(lb=0, vtype=GRB.INTEGER, name="bars")

    # Set objective function
    m.setObjective(8 * pizza * pies + 8 * pies**2 + 9 * sandwiches**2 + sandwiches, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10 * sandwiches**2 + 18 * bars**2 >= 42, "c0")
    m.addConstr(8 * pizza + 18 * bars >= 37, "c1")
    m.addConstr(8 * pizza + 15 * pies >= 21, "c2")
    m.addConstr(8 * pizza + 15 * pies + 10 * sandwiches + 18 * bars >= 21, "c3")
    m.addConstr(6 * pizza + 5 * pies >= 30, "c4")
    m.addConstr(6 * pizza**2 + 24 * bars**2 >= 50, "c5")
    m.addConstr(14 * sandwiches + 24 * bars >= 41, "c6")
    m.addConstr(6 * pizza + 14 * sandwiches >= 49, "c7")
    m.addConstr(6 * pizza + 5 * pies + 14 * sandwiches + 24 * bars >= 49, "c8")
    m.addConstr(3 * pizza**2 + sandwiches**2 >= 19, "c9")
    m.addConstr(3 * pizza + 8 * pies >= 15, "c10")
    m.addConstr(8 * pies**2 + 15 * bars**2 >= 22, "c11")
    m.addConstr(3 * pizza + 8 * pies + sandwiches + 15 * bars >= 22, "c12")
    m.addConstr(4 * pizza**2 - 7 * sandwiches**2 >= 0, "c13")
    m.addConstr(15 * pies + 18 * bars <= 223, "c14")
    m.addConstr(8 * pizza + 18 * bars <= 182, "c15")
    m.addConstr(8 * pizza**2 + 10 * sandwiches**2 <= 85, "c16")
    m.addConstr(10 * sandwiches**2 + 18 * bars**2 <= 189, "c17")
    m.addConstr(15 * pies**2 + 10 * sandwiches**2 <= 159, "c18")
    m.addConstr(8 * pizza + 15 * pies <= 140, "c19")
    m.addConstr(8 * pizza + 10 * sandwiches + 18 * bars <= 241, "c20")
    m.addConstr(15 * pies + 10 * sandwiches + 18 * bars <= 130, "c21")
    m.addConstr(8 * pizza + 15 * pies + 18 * bars <= 231, "c22")
    m.addConstr(8 * pizza + 15 * pies + 10 * sandwiches <= 216, "c23")
    m.addConstr(6 * pizza + 14 * sandwiches <= 139, "c24")
    m.addConstr(6 * pizza + 5 * pies <= 110, "c25")
    m.addConstr(5 * pies**2 + 14 * sandwiches**2 <= 200, "c26")
    m.addConstr(6 * pizza + 24 * bars <= 239, "c27")
    m.addConstr(6 * pizza + 5 * pies + 24 * bars <= 156, "c28")
    m.addConstr(8 * pies + 15 * bars <= 86, "c29")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
