
import gurobi

def optimize():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="slices_of_pizza")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="cherry_pies")
    x2 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="peanutbutter_sandwiches", integrality=gurobi.GRB.INTEGER)
    x3 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="protein_bars", integrality=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8*x0*x1 + 8*x1**2 + 9*x2**2 + x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8*x0 + 15*x1 + 10*x2 + 18*x3 <= 255, name="total_cost")
    model.addConstr(6*x0 + 5*x1 + 14*x2 + 24*x3 <= 271, name="total_calcium")
    model.addConstr(3*x0 + 8*x1 + x2 + 15*x3 <= 146, name="total_protein")

    model.addConstr(10*x2 + 18*x3 >= 42, name="peanutbutter_sandwiches_and_protein_bars_cost")
    model.addConstr(8*x0 + 18*x3 >= 37, name="slices_of_pizza_and_protein_bars_cost")
    model.addConstr(8*x0 + 15*x1 + 10*x2 + 18*x3 >= 21, name="all_items_cost")
    model.addConstr(8*x0 + 15*x1 >= 21, name="slices_of_pizza_and_cherry_pies_cost")

    model.addConstr(6*x0 + 5*x1 >= 30, name="calcium_from_pizza_and_pies")
    model.addConstr((6*x0)**2 + (24*x3)**2 >= 50, name="calcium_from_pizza_and_protein_bars_squared")
    model.addConstr(14*x2 + 24*x3 >= 41, name="calcium_from_peanutbutter_sandwiches_and_protein_bars")
    model.addConstr(6*x0 + 14*x2 >= 49, name="calcium_from_pizza_and_peanutbutter_sandwiches")
    model.addConstr(6*x0 + 5*x1 + 14*x2 + 24*x3 >= 49, name="total_calcium_from_all_items")

    model.addConstr((3*x0)**2 + (x2)**2 >= 19, name="protein_from_pizza_and_peanutbutter_sandwiches_squared")
    model.addConstr(3*x0 + 8*x1 >= 15, name="protein_from_pizza_and_pies")
    model.addConstr((8*x1)**2 + (15*x3)**2 >= 22, name="protein_from_pies_and_protein_bars_squared")
    model.addConstr(3*x0 + 8*x1 + x2 + 15*x3 >= 22, name="total_protein_from_all_items")

    model.addConstr(4*x0**2 - 7*x2**2 >= 0, name="pizza_and_peanutbutter_sandwiches_interaction")

    model.addConstr(15*x1 + 18*x3 <= 223, name="cherry_pies_and_protein_bars_cost")
    model.addConstr(8*x0 + 18*x3 <= 182, name="slices_of_pizza_and_protein_bars_cost")
    model.addConstr(8*x0**2 + x2**2 <= 85, name="pizza_and_peanutbutter_sandwiches_cost_squared")
    model.addConstr(x2**2 + x3**2 <= 189, name="peanutbutter_sandwiches_and_protein_bars_cost_squared")
    model.addConstr(x1**2 + x2**2 <= 159, name="cherry_pies_and_peanutbutter_sandwiches_cost_squared")

    model.addConstr(8*x0 + 15*x1 <= 140, name="slices_of_pizza_and_cherry_pies_cost")
    model.addConstr(8*x0 + 10*x2 + 18*x3 <= 241, name="slices_of_pizza_peanutbutter_sandwiches_and_protein_bars_cost")
    model.addConstr(15*x1 + 10*x2 + 18*x3 <= 130, name="cherry_pies_peanutbutter_sandwiches_and_protein_bars_cost")
    model.addConstr(8*x0 + 15*x1 + 18*x3 <= 231, name="slices_of_pizza_cherry_pies_and_protein_bars_cost")
    model.addConstr(8*x0 + 15*x1 + 10*x2 <= 216, name="slices_of_pizza_cherry_pies_and_peanutbutter_sandwiches_cost")

    model.addConstr(6*x0 + 14*x2 <= 139, name="calcium_from_pizza_and_peanutbutter_sandwiches")
    model.addConstr(6*x0 + 5*x1 <= 110, name="calcium_from_pizza_and_pies")
    model.addConstr((5*x1)**2 + (14*x2)**2 <= 200, name="calcium_from_pies_and_peanutbutter_sandwiches_squared")
    model.addConstr(6*x0 + 24*x3 <= 239, name="calcium_from_pizza_and_protein_bars")
    model.addConstr(6*x0 + 5*x1 + 24*x3 <= 156, name="calcium_from_pizza_pies_and_protein_bars")

    model.addConstr(8*x1 + 15*x3 <= 86, name="protein_from_pies_and_protein_bars")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("slices_of_pizza: ", x0.x)
        print("cherry_pies: ", x1.x)
        print("peanutbutter_sandwiches: ", x2.x)
        print("protein_bars: ", x3.x)
    else:
        print("No optimal solution found")

optimize()
