
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
ramen = m.addVar(vtype=gp.GRB.INTEGER, name="ramen")
corn = m.addVar(vtype=gp.GRB.INTEGER, name="corn")
cereal = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cereal")

# Set objective function
m.setObjective(2.11 * ramen + 9.07 * corn + 3.76 * cereal, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16 * ramen + 28 * cereal >= 73, "calcium_ramen_cereal")
m.addConstr(30 * corn + 28 * cereal >= 30, "calcium_corn_cereal")
m.addConstr(16 * ramen + 30 * corn + 28 * cereal >= 30, "calcium_all")
m.addConstr(16 * ramen + 30 * corn + 28 * cereal <= 113, "calcium_upper_bound") # corrected constraint
m.addConstr(-9 * ramen + 6 * cereal >= 0, "ramen_cereal_relation")
m.addConstr(-2 * ramen + 8 * corn >= 0, "ramen_corn_relation")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('ramen:', ramen.x)
    print('corn:', corn.x)
    print('cereal:', cereal.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

