
from gurobipy import *

# Create a model
m = Model("Optimization_Model")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="Bowls_of_Instant_Ramen")
x1 = m.addVar(vtype=GRB.INTEGER, name="Corn_Cobs")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Bowls_of_Cereal")

# Objective function
m.setObjective(2.11*x0 + 9.07*x1 + 3.76*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(16*x0 + 28*x2 >= 73, "Calcium_from_Instant_Ramen_and_Cereal")
m.addConstr(30*x1 + 28*x2 >= 30, "Calcium_from_Corn_Cobs_and_Cereal")
m.addConstr(16*x0 + 30*x1 + 28*x2 >= 30, "Calcium_from_All_Sources")
m.addConstr(-9*x0 + 6*x2 >= 0, "Relationship_Between_Instant_Ramen_and_Cereal")
m.addConstr(-2*x0 + 8*x1 >= 0, "Relationship_Between_Instant_Ramen_and_Corn_Cobs")
m.addConstr(16*x0 + 30*x1 + 28*x2 <= 113, "Total_Calcium_Limit")

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
