
import gurobipy as gp

# Create a new model
m = gp.Model("calcium_optimization")

# Define variables
bowls_ramen = m.addVar(name="bowls_ramen", lowBound=0, vtype=gp.GRB.INTEGER)
corn_cobs = m.addVar(name="corn_cobs", lowBound=0, vtype=gp.GRB.INTEGER)
bowls_cereal = m.addVar(name="bowls_cereal", lowBound=0)

# Objective function
m.setObjective(2.11 * bowls_ramen + 9.07 * corn_cobs + 3.76 * bowls_cereal, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(16 * bowls_ramen + 28 * bowls_cereal >= 73, name="min_calcium_ramen_cereal")
m.addConstr(30 * corn_cobs + 28 * bowls_cereal >= 30, name="min_calcium_corn_cereal")
m.addConstr(16 * bowls_ramen + 30 * corn_cobs + 28 * bowls_cereal >= 30, name="min_calcium_all")
m.addConstr(-9 * bowls_ramen + 6 * bowls_cereal >= 0, name="constraint_ramen_cereal")
m.addConstr(-2 * bowls_ramen + 8 * corn_cobs >= 0, name="constraint_ramen_corn")
m.addConstr(16 * bowls_ramen + 30 * corn_cobs + 28 * bowls_cereal <= 113, name="max_calcium_all")

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bowls of instant ramen: {bowls_ramen.varValue}")
    print(f"Corn cobs: {corn_cobs.varValue}")
    print(f"Bowls of cereal: {bowls_cereal.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
