
from gurobipy import Model, GRB

# Create a new model
m = Model("Military Optimization")

# Create variables
military_intelligence = m.addVar(vtype=GRB.INTEGER, name="x0")
water_purification = m.addVar(vtype=GRB.INTEGER, name="x1")
armored_companies = m.addVar(vtype=GRB.INTEGER, name="x2")
light_infantry = m.addVar(vtype=GRB.INTEGER, name="x3")

# Set objective function
m.setObjective(7 * military_intelligence + 3 * water_purification + 9 * armored_companies + 3 * light_infantry, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * military_intelligence + 6 * water_purification + 6 * armored_companies >= 12, "c0")
m.addConstr(4 * military_intelligence + 4 * water_purification >= 5, "c1")
m.addConstr(4 * military_intelligence + 4 * water_purification + 7 * light_infantry >= 9, "c2")
m.addConstr(6 * armored_companies + 4 * light_infantry <= 35, "c3")
m.addConstr(2 * military_intelligence + 6 * water_purification <= 43, "c4")
m.addConstr(2 * military_intelligence + 4 * light_infantry <= 31, "c5")
m.addConstr(2 * military_intelligence + 6 * armored_companies <= 47, "c6")
m.addConstr(6 * water_purification + 6 * armored_companies <= 37, "c7")
m.addConstr(6 * water_purification + 6 * armored_companies + 4 * light_infantry <= 39, "c8")
m.addConstr(2 * military_intelligence + 6 * water_purification + 6 * armored_companies + 4 * light_infantry <= 39, "c9")
m.addConstr(1 * armored_companies + 7 * light_infantry <= 30, "c10")
m.addConstr(4 * military_intelligence + 4 * water_purification <= 36, "c11")
m.addConstr(4 * water_purification + 7 * light_infantry <= 30, "c12")
m.addConstr(4 * water_purification + 1 * armored_companies <= 26, "c13")
m.addConstr(4 * military_intelligence + 1 * armored_companies <= 18, "c14")
m.addConstr(4 * military_intelligence + 4 * water_purification + 1 * armored_companies + 7 * light_infantry <= 18, "c15")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

