
from gurobipy import *

# Define the model
m = Model("Military_Resource_Optimization")

# Define variables (quantities of each type)
x0 = m.addVar(vtype=GRB.INTEGER, name="military_intelligence_companies")
x1 = m.addVar(vtype=GRB.INTEGER, name="water_purification_units")
x2 = m.addVar(vtype=GRB.INTEGER, name="armored_companies")
x3 = m.addVar(vtype=GRB.INTEGER, name="light_infantry_companies")

# Objective function
m.setObjective(7*x0 + 3*x1 + 9*x2 + 3*x3, GRB.MAXIMIZE)

# Defensive capability constraints
m.addConstr(2*x0 + 6*x1 + 6*x2 + 4*x3 <= 39, "Total_Defensive_Capability_Max")
m.addConstr(2*x0 + 6*x1 >= 12, "Minimum_Defensive_Capability_Water_Purification_Military_Intelligence")
m.addConstr(6*x2 + 4*x3 <= 35, "Defensive_Capability_Armored_Light_Infantry_Max")
m.addConstr(2*x0 + 6*x1 <= 43, "Defensive_Capability_Water_Purification_Military_Intelligence_Max")
m.addConstr(2*x0 + 4*x3 <= 31, "Defensive_Capability_Military_Intelligence_Light_Infantry_Max")
m.addConstr(2*x0 + 6*x2 <= 47, "Defensive_Capability_Armored_Military_Intelligence_Max")
m.addConstr(6*x1 + 6*x2 <= 37, "Defensive_Capability_Water_Purification_Armored_Max")
m.addConstr(6*x1 + 6*x2 + 4*x3 <= 39, "Defensive_Capability_Water_Purification_Armored_Light_Infantry_Max")

# Logistics footprint constraints
m.addConstr(4*x0 + 4*x1 >= 5, "Minimum_Logistics_Footprint_Military_Intelligence_Water_Purification")
m.addConstr(4*x0 + 4*x1 + 7*x3 >= 9, "Minimum_Logistics_Footprint_All_Units")
m.addConstr(x2 + 7*x3 <= 30, "Logistics_Footprint_Armored_Light_Infantry_Max")
m.addConstr(4*x0 + 4*x1 <= 36, "Logistics_Footprint_Military_Intelligence_Water_Purification_Max")
m.addConstr(4*x1 + 7*x3 <= 30, "Logistics_Footprint_Water_Purification_Light_Infantry_Max")
m.addConstr(4*x1 + x2 <= 26, "Logistics_Footprint_Water_Purification_Armored_Max")
m.addConstr(4*x0 + x2 <= 18, "Logistics_Footprint_Military_Intelligence_Armored_Max")
m.addConstr(4*x0 + 4*x1 + x2 + 7*x3 <= 58, "Total_Logistics_Footprint_Max")

# Solve the model
m.optimize()

# Print results
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))
