
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(vtype=gurobi.GRB.INTEGER, name="military_intelligence_companies")
    x1 = model.addVar(vtype=gurobi.GRB.INTEGER, name="water_purification_units")
    x2 = model.addVar(vtype=gurobi.GRB.INTEGER, name="armored_companies")
    x3 = model.addVar(vtype=gurobi.GRB.INTEGER, name="light_infantry_companies")

    # Define the objective function
    model.setObjective(7 * x0 + 3 * x1 + 9 * x2 + 3 * x3, gurobi.GRB.MAXIMIZE)

    # Defensive capability rating constraints
    model.addConstr(2 * x0 + 6 * x1 + 6 * x2 >= 12, name="defensive_capability_rating_1")
    model.addConstr(2 * x0 + 6 * x1 + 4 * x3 <= 43, name="defensive_capability_rating_2")
    model.addConstr(2 * x0 + 4 * x3 <= 31, name="defensive_capability_rating_3")
    model.addConstr(2 * x0 + 6 * x2 <= 47, name="defensive_capability_rating_4")
    model.addConstr(6 * x1 + 6 * x2 + 4 * x3 <= 39, name="defensive_capability_rating_5")
    model.addConstr(2 * x0 + 6 * x1 + 6 * x2 + 4 * x3 <= 39, name="defensive_capability_rating_6")

    # Logistics footprint constraints
    model.addConstr(4 * x0 + 4 * x1 >= 5, name="logistics_footprint_1")
    model.addConstr(4 * x0 + 4 * x1 + 7 * x3 >= 9, name="logistics_footprint_2")
    model.addConstr(x2 + 7 * x3 <= 30, name="logistics_footprint_3")
    model.addConstr(4 * x0 + 4 * x1 <= 36, name="logistics_footprint_4")
    model.addConstr(4 * x1 + 7 * x3 <= 30, name="logistics_footprint_5")
    model.addConstr(4 * x1 + x2 <= 26, name="logistics_footprint_6")
    model.addConstr(4 * x0 + x2 <= 18, name="logistics_footprint_7")
    model.addConstr(4 * x0 + 4 * x1 + x2 + 7 * x3 <= 18, name="logistics_footprint_8")

    # Non-negativity constraints
    model.addConstr(x0 >= 0, name="non_negativity_x0")
    model.addConstr(x1 >= 0, name="non_negativity_x1")
    model.addConstr(x2 >= 0, name="non_negativity_x2")
    model.addConstr(x3 >= 0, name="non_negativity_x3")

    # Integrate all the changes
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"military_intelligence_companies: {x0.varValue}")
        print(f"water_purification_units: {x1.varValue}")
        print(f"armored_companies: {x2.varValue}")
        print(f"light_infantry_companies: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
