
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
green_beans = model.addVar(vtype=GRB.INTEGER, name="green_beans")
protein_bars = model.addVar(vtype=GRB.INTEGER, name="protein_bars")
cornichons = model.addVar(vtype=GRB.INTEGER, name="cornichons")

# Set objective function
model.setObjective(4.82 * green_beans + 2.3 * protein_bars + 7.85 * cornichons, GRB.MAXIMIZE)

# Add constraints
model.addConstr(23 * green_beans + 21 * protein_bars + 21 * cornichons >= 62, "fat_min")
model.addConstr(21 * green_beans + 1 * protein_bars >= 49, "protein_gb_pb_min")
model.addConstr(1 * protein_bars + 31 * cornichons >= 41, "protein_pb_c_min")
model.addConstr(21 * green_beans + 1 * protein_bars + 31 * cornichons >= 37, "protein_total_min")
model.addConstr(22 * protein_bars + 29 * cornichons >= 98, "umami_pb_c_min")
model.addConstr(13 * green_beans + 22 * protein_bars >= 65, "umami_gb_pb_min")
model.addConstr(13 * green_beans + 22 * protein_bars + 29 * cornichons >= 78, "umami_total_min")
model.addConstr(5 * protein_bars + 16 * cornichons >= 59, "calcium_pb_c_min")
model.addConstr(11 * green_beans + 16 * cornichons >= 95, "calcium_gb_c_min")
model.addConstr(11 * green_beans + 5 * protein_bars >= 129, "calcium_gb_pb_min")

model.addConstr(23 * green_beans + 21 * protein_bars <= 128, "fat_gb_pb_max")
model.addConstr(23 * green_beans + 21 * cornichons <= 201, "fat_gb_c_max")
model.addConstr(21 * protein_bars + 21 * cornichons <= 191, "fat_pb_c_max")
model.addConstr(23 * green_beans + 21 * protein_bars + 21 * cornichons <= 191, "fat_total_max")

model.addConstr(21 * green_beans + 1 * protein_bars <= 120, "protein_gb_pb_max")
model.addConstr(1 * protein_bars + 31 * cornichons <= 72, "protein_pb_c_max")
model.addConstr(21 * green_beans + 1 * protein_bars + 31 * cornichons <= 102, "protein_total_max")

model.addConstr(27 * green_beans + 28 * protein_bars <= 215, "carbs_gb_pb_max")
model.addConstr(28 * protein_bars + 16 * cornichons <= 339, "carbs_pb_c_max")
model.addConstr(27 * green_beans + 16 * cornichons <= 258, "carbs_gb_c_max")
model.addConstr(27 * green_beans + 28 * protein_bars + 16 * cornichons <= 328, "carbs_total_max")

model.addConstr(22 * protein_bars + 29 * cornichons <= 383, "umami_pb_c_max")
model.addConstr(13 * green_beans + 29 * cornichons <= 182, "umami_gb_c_max")
model.addConstr(13 * green_beans + 22 * protein_bars + 29 * cornichons <= 182, "umami_total_max")

model.addConstr(11 * green_beans + 5 * protein_bars <= 175, "calcium_gb_pb_max")
model.addConstr(11 * green_beans + 5 * protein_bars + 16 * cornichons <= 175, "calcium_total_max")


# Resource Constraints (given in the CONTEXT section)
model.addConstr(23 * green_beans + 21 * protein_bars + 21 * cornichons <= 328, "fat_resource_max")
model.addConstr(21 * green_beans + 1 * protein_bars + 31 * cornichons <= 147, "protein_resource_max")
model.addConstr(27 * green_beans + 28 * protein_bars + 16 * cornichons <= 394, "carbs_resource_max")
model.addConstr(13 * green_beans + 22 * protein_bars + 29 * cornichons <= 383, "umami_resource_max")
model.addConstr(11 * green_beans + 5 * protein_bars + 16 * cornichons <= 429, "calcium_resource_max")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('green_beans:', green_beans.x)
    print('protein_bars:', protein_bars.x)
    print('cornichons:', cornichons.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

