
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
peanutbutter_sandwiches = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peanutbutter_sandwiches")
chicken_thighs = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_thighs")
sashimi = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sashimi")
apple_pies = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")

# Set objective function
model.setObjective(6.81 * peanutbutter_sandwiches + 5.9 * chicken_thighs + 9.09 * sashimi + 4.3 * apple_pies, GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * peanutbutter_sandwiches + 5 * chicken_thighs >= 21, "iron_constraint1")
model.addConstr(5 * chicken_thighs + 4 * sashimi >= 19, "iron_constraint2")
model.addConstr(6 * peanutbutter_sandwiches + 5 * chicken_thighs + 4 * sashimi >= 24, "iron_constraint3")
model.addConstr(6 * peanutbutter_sandwiches + 4 * sashimi + 10 * apple_pies >= 24, "iron_constraint4")
model.addConstr(5 * chicken_thighs + 4 * sashimi + 10 * apple_pies >= 24, "iron_constraint5")
model.addConstr(6 * peanutbutter_sandwiches + 5 * chicken_thighs + 4 * sashimi >= 12, "iron_constraint6")
model.addConstr(6 * peanutbutter_sandwiches + 4 * sashimi + 10 * apple_pies >= 12, "iron_constraint7")
model.addConstr(5 * chicken_thighs + 4 * sashimi + 10 * apple_pies >= 12, "iron_constraint8")
model.addConstr(6 * peanutbutter_sandwiches + 5 * chicken_thighs + 4 * sashimi >= 13, "iron_constraint9")
model.addConstr(6 * peanutbutter_sandwiches + 4 * sashimi + 10 * apple_pies >= 13, "iron_constraint10")
model.addConstr(5 * chicken_thighs + 4 * sashimi + 10 * apple_pies >= 13, "iron_constraint11")
model.addConstr(6 * peanutbutter_sandwiches + 5 * chicken_thighs + 4 * sashimi + 10 * apple_pies >= 13, "iron_constraint12")

model.addConstr(9 * peanutbutter_sandwiches + 1 * apple_pies >= 16, "tastiness_constraint1")
model.addConstr(2 * sashimi + 1 * apple_pies >= 13, "tastiness_constraint2")
model.addConstr(9 * peanutbutter_sandwiches + 4 * chicken_thighs >= 8, "tastiness_constraint3")
model.addConstr(4 * chicken_thighs + 2 * sashimi >= 11, "tastiness_constraint4")
model.addConstr(4 * chicken_thighs + 1 * apple_pies >= 9, "tastiness_constraint5")
model.addConstr(9 * peanutbutter_sandwiches + 4 * chicken_thighs + 2 * sashimi + 1 * apple_pies >= 9, "tastiness_constraint6")

model.addConstr(2 * chicken_thighs - 8 * apple_pies >= 0, "constraint1")
model.addConstr(9 * sashimi - 8 * apple_pies >= 0, "constraint2")
model.addConstr(5 * chicken_thighs + 4 * sashimi <= 91, "iron_constraint13")
model.addConstr(5 * chicken_thighs + 10 * apple_pies <= 57, "iron_constraint14")
model.addConstr(4 * chicken_thighs + 1 * apple_pies <= 16, "tastiness_constraint7")
model.addConstr(9 * peanutbutter_sandwiches + 2 * sashimi <= 34, "tastiness_constraint8")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

