
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="peanutbutter_sandwiches", lb=0)  # peanutbutter sandwiches
x1 = m.addVar(name="chicken_thighs", lb=0)  # chicken thighs
x2 = m.addVar(name="sashimi", lb=0)  # sashimi
x3 = m.addVar(name="apple_pies", lb=0)  # apple pies

# Define the objective function
m.setObjective(6.81 * x0 + 5.9 * x1 + 9.09 * x2 + 4.3 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * x0 + 5 * x1 + 4 * x2 + 10 * x3 <= 97)  # iron upper bound
m.addConstr(9 * x0 + 4 * x1 + 2 * x2 + x3 <= 66)  # tastiness rating upper bound
m.addConstr(6 * x0 + 5 * x1 >= 21)  # iron from peanutbutter sandwiches and chicken thighs
m.addConstr(5 * x1 + 4 * x2 >= 19)  # iron from chicken thighs and sashimi
m.addConstr(6 * x0 + 5 * x1 + 4 * x2 >= 24)  # iron from peanutbutter sandwiches, chicken thighs, and sashimi
m.addConstr(6 * x0 + 4 * x2 + 10 * x3 >= 24)  # iron from peanutbutter sandwiches, sashimi, and apple pies
m.addConstr(5 * x1 + 4 * x2 + 10 * x3 >= 24)  # iron from chicken thighs, sashimi, and apple pies
m.addConstr(6 * x0 + 5 * x1 + 4 * x2 >= 12)  # iron from peanutbutter sandwiches, chicken thighs, and sashimi
m.addConstr(6 * x0 + 4 * x2 + 10 * x3 >= 12)  # iron from peanutbutter sandwiches, sashimi, and apple pies
m.addConstr(5 * x1 + 4 * x2 + 10 * x3 >= 12)  # iron from chicken thighs, sashimi, and apple pies
m.addConstr(6 * x0 + 5 * x1 + 4 * x2 >= 13)  # iron from peanutbutter sandwiches, chicken thighs, and sashimi
m.addConstr(6 * x0 + 4 * x2 + 10 * x3 >= 13)  # iron from peanutbutter sandwiches, sashimi, and apple pies
m.addConstr(5 * x1 + 4 * x2 + 10 * x3 >= 13)  # iron from chicken thighs, sashimi, and apple pies
m.addConstr(6 * x0 + 5 * x1 + 4 * x2 + 10 * x3 >= 13)  # iron from all
m.addConstr(9 * x0 + x3 >= 16)  # tastiness rating from peanutbutter sandwiches and apple pies
m.addConstr(2 * x2 + x3 >= 13)  # tastiness rating from sashimi and apple pies
m.addConstr(9 * x0 + 4 * x1 >= 8)  # tastiness rating from peanutbutter sandwiches and chicken thighs
m.addConstr(4 * x1 + 2 * x2 >= 11)  # tastiness rating from chicken thighs and sashimi
m.addConstr(4 * x1 + x3 >= 9)  # tastiness rating from chicken thighs and apple pies
m.addConstr(9 * x0 + 4 * x1 + 2 * x2 + x3 >= 9)  # total tastiness rating
m.addConstr(2 * x1 - 8 * x3 >= 0)  # relationship between chicken thighs and apple pies
m.addConstr(9 * x2 - 8 * x3 >= 0)  # relationship between sashimi and apple pies
m.addConstr(5 * x1 + 4 * x2 <= 91)  # iron from chicken thighs and sashimi
m.addConstr(5 * x1 + 10 * x3 <= 57)  # iron from chicken thighs and apple pies
m.addConstr(4 * x1 + x3 <= 16)  # tastiness rating from chicken thighs and apple pies
m.addConstr(9 * x0 + 2 * x2 <= 34)  # tastiness rating from peanutbutter sandwiches and sashimi

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("peanutbutter sandwiches: ", x0.varValue)
    print("chicken thighs: ", x1.varValue)
    print("sashimi: ", x2.varValue)
    print("apple pies: ", x3.varValue)
else:
    print("The model is infeasible")
