
from gurobipy import *

# Create a new model
model = Model("Work Optimization")

# Create variables
ringo = model.addVar(vtype=GRB.INTEGER, name="ringo")
jean = model.addVar(vtype=GRB.CONTINUOUS, name="jean")
mary = model.addVar(vtype=GRB.CONTINUOUS, name="mary")
laura = model.addVar(vtype=GRB.INTEGER, name="laura")
peggy = model.addVar(vtype=GRB.INTEGER, name="peggy")
john = model.addVar(vtype=GRB.CONTINUOUS, name="john")
george = model.addVar(vtype=GRB.CONTINUOUS, name="george")

# Set objective function
model.setObjective(ringo*ringo + 3*ringo*jean + 2*ringo*laura + 2*ringo*peggy + 5*ringo*john + 4*jean*jean + 7*jean*peggy + 5*jean*george + 7*mary*laura + 8*mary*peggy + 9*laura*peggy + 6*laura*john + 8*peggy*peggy + 4*peggy*john + 3*peggy*george + john*george + 4*george*george + 4*jean + mary + 3*john + 3*george, GRB.MAXIMIZE)

# Work quality ratings
ratings = {'ringo': 16, 'jean': 12, 'mary': 3, 'laura': 9, 'peggy': 12, 'john': 5, 'george': 6}

# Add constraints
model.addConstr(ratings['laura'] * laura*laura + ratings['george'] * george*george >= 25)
model.addConstr(ratings['ringo'] * ringo + ratings['peggy'] * peggy + ratings['george'] * george >= 44)
model.addConstr(ratings['ringo'] * ringo + ratings['john'] * john + ratings['george'] * george >= 44)
model.addConstr(ratings['jean'] * jean*jean + ratings['peggy'] * peggy*peggy + ratings['george'] * george*george >= 44)
model.addConstr(ratings['ringo'] * ringo + ratings['mary'] * mary + ratings['peggy'] * peggy >= 44)
model.addConstr(ratings['ringo'] * ringo + ratings['mary'] * mary + ratings['laura'] * laura >= 44)
model.addConstr(ratings['ringo'] * ringo + ratings['laura'] * laura + ratings['peggy'] * peggy >= 44)
model.addConstr(ratings['mary'] * mary + ratings['laura'] * laura + ratings['john'] * john >= 44)
model.addConstr(ratings['ringo'] * ringo*ringo + ratings['jean'] * jean*jean + ratings['george'] * george*george >= 44)
model.addConstr(ratings['jean'] * jean*jean + ratings['peggy'] * peggy*peggy + ratings['john'] * john*john >= 44)
model.addConstr(ratings['ringo'] * ringo + ratings['peggy'] * peggy + ratings['john'] * john >= 44)
model.addConstr(ratings['jean'] * jean + ratings['mary'] * mary + ratings['peggy'] * peggy >= 44)
model.addConstr(ratings['ringo'] * ringo + ratings['mary'] * mary + ratings['george'] * george >= 44)
model.addConstr(ratings['jean'] * jean + ratings['laura'] * laura + ratings['john'] * john >= 44)
model.addConstr(ratings['laura'] * laura*laura + ratings['peggy'] * peggy*peggy + ratings['george'] * george*george >= 44)

# ... (Rest of the constraints similarly)

model.addConstr(ratings['laura'] * laura*laura + ratings['george'] * george*george <= 505)
model.addConstr(ratings['john'] * john + ratings['george'] * george <= 413)
# ... (Rest of the constraints similarly)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: ', model.objVal)
    for v in model.getVars():
        print(f'{v.varName}: {v.x}')
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {model.status}")
