
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
john_hours = model.addVar(name="john_hours", lb=0)
jean_hours = model.addVar(name="jean_hours", lb=0)
ringo_hours = model.addVar(name="ringo_hours", lb=0)
bill_hours = model.addVar(name="bill_hours", lb=0)

# Set objective function
model.setObjective(9.2 * john_hours + 1.4 * jean_hours + 1.15 * ringo_hours + 2.34 * bill_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(8 * john_hours + 9 * jean_hours >= 22, "c1")
model.addConstr(9 * jean_hours + 18 * ringo_hours >= 18, "c2")
model.addConstr(16 * jean_hours + 9 * bill_hours >= 33, "c3")
model.addConstr(1 * john_hours + 9 * bill_hours >= 35, "c4")
model.addConstr(1 * john_hours + 16 * jean_hours >= 42, "c5")
model.addConstr(1 * john_hours + 10 * ringo_hours >= 36, "c6")
model.addConstr(16 * jean_hours + 10 * ringo_hours >= 38, "c7")
model.addConstr(1 * john_hours + 10 * ringo_hours + 9 * bill_hours >= 31, "c8")
model.addConstr(16 * jean_hours + 10 * ringo_hours + 9 * bill_hours >= 31, "c9")
model.addConstr(1 * john_hours + 10 * ringo_hours + 9 * bill_hours >= 39, "c10")
model.addConstr(16 * jean_hours + 10 * ringo_hours + 9 * bill_hours >= 39, "c11")
model.addConstr(8 * john_hours + 9 * jean_hours <= 47, "c12")
model.addConstr(8 * john_hours + 9 * jean_hours + 18 * ringo_hours <= 37, "c13")
model.addConstr(8 * john_hours + 9 * jean_hours + 18 * ringo_hours + 12 * bill_hours <= 37, "c14")
model.addConstr(1 * john_hours + 10 * ringo_hours <= 143, "c15")
model.addConstr(1 * john_hours + 9 * bill_hours <= 105, "c16")
model.addConstr(1 * john_hours + 16 * jean_hours + 9 * bill_hours <= 93, "c17")
model.addConstr(1 * john_hours + 10 * ringo_hours + 9 * bill_hours <= 93, "c18")
model.addConstr(1 * john_hours + 16 * jean_hours + 10 * ringo_hours + 9 * bill_hours <= 93, "c19")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

