
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="hours_worked_by_John", lb=0)
    x1 = model.addVar(name="hours_worked_by_Jean", lb=0)
    x2 = model.addVar(name="hours_worked_by_Ringo", lb=0)
    x3 = model.addVar(name="hours_worked_by_Bill", lb=0)

    # Objective function
    model.setObjective(9.2*x0 + 1.4*x1 + 1.15*x2 + 2.34*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(8*x0 <= 105)
    model.addConstr(9*x1 <= 105)
    model.addConstr(18*x2 <= 105)
    model.addConstr(12*x3 <= 105)

    model.addConstr(8*x0 + 9*x1 >= 22)
    model.addConstr(9*x1 + 18*x2 >= 18)
    model.addConstr(16*x1 + 9*x3 >= 33)
    model.addConstr(x0 + 9*x3 >= 35)
    model.addConstr(x0 + 16*x1 >= 42)
    model.addConstr(x0 + 10*x2 >= 36)
    model.addConstr(16*x1 + 10*x2 >= 38)
    model.addConstr(x0 + 10*x2 + 9*x3 >= 31)
    model.addConstr(16*x1 + 10*x2 + 9*x3 >= 31)
    model.addConstr(x0 + 10*x2 + 9*x3 >= 39)
    model.addConstr(16*x1 + 10*x2 + 9*x3 >= 39)

    model.addConstr(8*x0 + 9*x1 <= 47)
    model.addConstr(8*x0 + 9*x1 + 18*x2 <= 37)
    model.addConstr(8*x0 + 9*x1 + 18*x2 + 12*x3 <= 37)

    model.addConstr(x0 + 10*x2 <= 143)
    model.addConstr(x0 + 9*x3 <= 105)
    model.addConstr(x0 + 16*x1 + 9*x3 <= 93)
    model.addConstr(x0 + 10*x2 + 9*x3 <= 93)
    model.addConstr(x0 + 16*x1 + 10*x2 + 9*x3 <= 93)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by John: ", x0.varValue)
        print("Hours worked by Jean: ", x1.varValue)
        print("Hours worked by Ringo: ", x2.varValue)
        print("Hours worked by Bill: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
