
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Hour Optimization")

# Create variables
mary_hours = model.addVar(vtype=GRB.INTEGER, name="Mary_Hours")
laura_hours = model.addVar(vtype=GRB.INTEGER, name="Laura_Hours")
peggy_hours = model.addVar(vtype=GRB.CONTINUOUS, name="Peggy_Hours")
john_hours = model.addVar(vtype=GRB.INTEGER, name="John_Hours")

# Set objective function
model.setObjective(6.59 * mary_hours + 2.27 * laura_hours + 9.41 * peggy_hours + 8.96 * john_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(1 * mary_hours + 5 * laura_hours >= 21, "Dollar Cost Constraint 1")
model.addConstr(1 * mary_hours + 14 * peggy_hours >= 39, "Dollar Cost Constraint 2")
model.addConstr(5 * laura_hours + 14 * peggy_hours + 1 * john_hours >= 45, "Dollar Cost Constraint 3")
model.addConstr(1 * mary_hours + 5 * laura_hours + 14 * peggy_hours + 1 * john_hours >= 45, "Dollar Cost Constraint 4")

model.addConstr(6 * laura_hours + 4 * john_hours >= 13, "Competence Rating Constraint 1")
model.addConstr(6 * peggy_hours + 4 * john_hours >= 25, "Competence Rating Constraint 2")
model.addConstr(6 * laura_hours + 6 * peggy_hours >= 11, "Competence Rating Constraint 3")
model.addConstr(15 * mary_hours + 6 * laura_hours + 6 * peggy_hours + 4 * john_hours >= 11, "Competence Rating Constraint 4")

model.addConstr(9 * peggy_hours - 4 * john_hours >= 0, "Peggy John Constraint")

model.addConstr(1 * mary_hours + 5 * laura_hours + 1 * john_hours <= 216, "Dollar Cost Constraint 5")
model.addConstr(5 * laura_hours + 14 * peggy_hours + 1 * john_hours <= 225, "Dollar Cost Constraint 6")
model.addConstr(1 * mary_hours + 5 * laura_hours + 14 * peggy_hours <= 134, "Dollar Cost Constraint 7")

model.addConstr(15 * mary_hours + 6 * laura_hours + 6 * peggy_hours <= 84, "Competence Rating Constraint 5")
model.addConstr(6 * laura_hours + 6 * peggy_hours + 4 * john_hours <= 112, "Competence Rating Constraint 6")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('\nCost: %g' % model.objVal)
    print('\nSolution:')
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

