
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
Mary_hours = m.addVar(vtype=GRB.INTEGER, name="Mary_hours")
Laura_hours = m.addVar(vtype=GRB.INTEGER, name="Laura_hours")
Peggy_hours = m.addVar(vtype=GRB.CONTINUOUS, name="Peggy_hours")
John_hours = m.addVar(vtype=GRB.INTEGER, name="John_hours")

# Objective function
m.setObjective(6.59 * Mary_hours + 2.27 * Laura_hours + 9.41 * Peggy_hours + 8.96 * John_hours, GRB.MINIMIZE)

# Constraints
m.addConstr(Mary_hours * 1 + Laura_hours * 5 >= 21, name="Dollar_Cost_Min_1")
m.addConstr(Mary_hours * 1 + Peggy_hours * 14 >= 39, name="Dollar_Cost_Min_2")
m.addConstr(Laura_hours * 5 + Peggy_hours * 14 + John_hours * 1 >= 45, name="Dollar_Cost_Min_3")
m.addConstr(Mary_hours * 1 + Laura_hours * 5 + Peggy_hours * 14 + John_hours * 1 >= 45, name="Dollar_Cost_Min_4")

m.addConstr(Laura_hours * 6 + John_hours * 4 >= 13, name="Computer_Rating_Min_1")
m.addConstr(Peggy_hours * 6 + John_hours * 4 >= 25, name="Computer_Rating_Min_2")
m.addConstr(Laura_hours * 6 + Peggy_hours * 6 >= 11, name="Computer_Rating_Min_3")
m.addConstr(Mary_hours * 15 + Laura_hours * 6 + Peggy_hours * 6 + John_hours * 4 >= 11, name="Computer_Rating_Min_4")

m.addConstr(9 * Peggy_hours - 4 * John_hours >= 0, name="Peggy_John_Relation")

m.addConstr(Mary_hours * 1 + Laura_hours * 5 + John_hours * 1 <= 216, name="Dollar_Cost_Max_1")
m.addConstr(Laura_hours * 5 + Peggy_hours * 14 + John_hours * 1 <= 225, name="Dollar_Cost_Max_2")
m.addConstr(Mary_hours * 1 + Laura_hours * 5 + Peggy_hours * 14 <= 134, name="Dollar_Cost_Max_3")

m.addConstr(Mary_hours * 15 + Laura_hours * 6 + Peggy_hours * 6 <= 84, name="Computer_Rating_Max_1")
m.addConstr(Laura_hours * 6 + Peggy_hours * 6 + John_hours * 4 <= 112, name="Computer_Rating_Max_2")

# Optimize model
m.optimize()
