
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="Mary", vtype=gurobi.GRB.INTEGER, lb=0)
    x1 = model.addVar(name="Laura", vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name="Peggy", vtype=gurobi.GRB.CONTINUOUS, lb=0)
    x3 = model.addVar(name="John", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function
    model.setObjective(6.59 * x0 + 2.27 * x1 + 9.41 * x2 + 8.96 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1 * x0 + 5 * x1 >= 21, name="cost_constraint_1")
    model.addConstr(1 * x0 + 14 * x2 >= 39, name="cost_constraint_2")
    model.addConstr(5 * x1 + 14 * x2 + 1 * x3 >= 45, name="cost_constraint_3")
    model.addConstr(1 * x0 + 5 * x1 + 14 * x2 + 1 * x3 >= 45, name="cost_constraint_4")
    model.addConstr(6 * x1 + 4 * x3 >= 13, name="rating_constraint_1")
    model.addConstr(6 * x2 + 4 * x3 >= 25, name="rating_constraint_2")
    model.addConstr(6 * x1 + 6 * x2 >= 11, name="rating_constraint_3")
    model.addConstr(15 * x0 + 6 * x1 + 6 * x2 + 4 * x3 >= 11, name="rating_constraint_4")
    model.addConstr(9 * x2 - 4 * x3 >= 0, name="peggy_john_constraint")
    model.addConstr(1 * x0 + 5 * x1 + 1 * x3 <= 216, name="cost_upper_bound_1")
    model.addConstr(5 * x1 + 14 * x2 + 1 * x3 <= 225, name="cost_upper_bound_2")
    model.addConstr(1 * x0 + 5 * x1 + 14 * x2 <= 134, name="cost_upper_bound_3")
    model.addConstr(15 * x0 + 6 * x1 + 6 * x2 <= 84, name="rating_upper_bound_1")
    model.addConstr(6 * x1 + 6 * x2 + 4 * x3 <= 112, name="rating_upper_bound_2")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Mary: ", x0.varValue)
        print("Laura: ", x1.varValue)
        print("Peggy: ", x2.varValue)
        print("John: ", x3.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
