
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Combined Hours Cost")

# Create variables
dale_hours = model.addVar(vtype=GRB.INTEGER, name="dale_hours")
john_hours = model.addVar(vtype=GRB.CONTINUOUS, name="john_hours")

# Set objective function
model.setObjective(8.6 * dale_hours * john_hours + 8.47 * john_hours * john_hours + 3.71 * dale_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(8 * dale_hours * dale_hours + 13 * john_hours * john_hours >= 22, "computer_competence_squared_min")
model.addConstr(8 * dale_hours + 13 * john_hours >= 22, "computer_competence_min")
model.addConstr(15 * dale_hours + 13 * john_hours >= 39, "dollar_cost_min")
model.addConstr(15 * dale_hours + 13 * john_hours <= 43, "dollar_cost_max")  # Added upper bound
model.addConstr(2 * dale_hours - john_hours >= 0, "dale_john_ratio")
model.addConstr(8 * dale_hours * dale_hours + 13 * john_hours * john_hours <= 79, "computer_competence_squared_max")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Dale's Hours: {dale_hours.x}")
    print(f"John's Hours: {john_hours.x}")
    print(f"Objective Value: {model.objVal}")

