
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
dale_hours = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Dale")
john_hours = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_John")

# Objective function
m.setObjective(8.6 * dale_hours * john_hours + 8.47 * john_hours**2 + 3.71 * dale_hours, GRB.MINIMIZE)

# Constraints
m.addConstr((8 * dale_hours)**2 + (13 * john_hours)**2 >= 22, name="min_total_comp_rating_squared")
m.addConstr(8 * dale_hours + 13 * john_hours >= 22, name="min_total_comp_rating")
m.addConstr(15 * dale_hours + 13 * john_hours >= 39, name="min_total_dollar_cost_per_hour_1")
m.addConstr(15 * dale_hours + 13 * john_hours >= 39, name="min_total_dollar_cost_per_hour_2")
m.addConstr(2 * dale_hours - john_hours >= 0, name="hours_worked_constraint")
m.addConstr((8 * dale_hours)**2 + (13 * john_hours)**2 <= 79, name="max_total_comp_rating_squared")
m.addConstr(15 * dale_hours + 13 * john_hours <= 43, name="max_total_dollar_cost_per_hour")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by Dale:", dale_hours.x)
    print("Hours worked by John:", john_hours.x)
else:
    print("No optimal solution found. Status:", m.status)

