
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    dale_hours = model.addVar(name="dale_hours", lb=0, type=gurobi.GRB.INTEGER)
    john_hours = model.addVar(name="john_hours", lb=0)

    # Objective function
    model.setObjective(8.6 * dale_hours * john_hours + 8.47 * john_hours**2 + 3.71 * dale_hours, gurobi.GRB.MINIMIZE)

    # Constraints
    # 5. The total combined computer competence rating from hours worked by Dale squared and hours worked by John squared must be at least 22.
    model.addConstr(8**2 * dale_hours**2 + 13**2 * john_hours**2 >= 22, "computer_competence_rating_squared_min")

    # 6. The total combined computer competence rating from hours worked by Dale plus hours worked by John must be at least 22.
    model.addConstr(8 * dale_hours + 13 * john_hours >= 22, "computer_competence_rating_min")

    # 7. The total combined dollar cost per hour from hours worked by Dale plus hours worked by John must be at least 39.
    model.addConstr(15 * dale_hours + 13 * john_hours >= 39, "dollar_cost_min")

    # 8. 2 times the number of hours worked by Dale, plus -1 times the number of hours worked by John should be greater than or equal to zero.
    model.addConstr(2 * dale_hours - john_hours >= 0, "dale_john_hours_relation")

    # 9. The total combined computer competence rating from hours worked by Dale squared and hours worked by John squared should be at maximum 79.
    model.addConstr(8**2 * dale_hours**2 + 13**2 * john_hours**2 <= 79, "computer_competence_rating_squared_max")

    # 10. The total combined dollar cost per hour from hours worked by Dale plus hours worked by John must be at most 43.
    model.addConstr(15 * dale_hours + 13 * john_hours <= 43, "dollar_cost_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Dale's hours: {dale_hours.varValue}")
        print(f"John's hours: {john_hours.varValue}")
    else:
        print("No optimal solution found.")

optimization_problem()
