
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hot_dogs")
cornichons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")
strawberries = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")

# Set objective function
m.setObjective(7 * hot_dogs + 6 * cornichons + 8 * strawberries, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(22 * hot_dogs + 9 * strawberries >= 53, "protein_constraint1")
m.addConstr(3 * cornichons + 9 * strawberries >= 34, "protein_constraint2")
m.addConstr(22 * hot_dogs + 3 * cornichons >= 35, "protein_constraint3")
m.addConstr(22 * hot_dogs + 3 * cornichons + 9 * strawberries >= 35, "protein_constraint4")

m.addConstr(23 * hot_dogs + 19 * cornichons >= 26, "fat_constraint1")
m.addConstr(23 * hot_dogs + 7 * strawberries >= 46, "fat_constraint2")
m.addConstr(23 * hot_dogs + 19 * cornichons + 7 * strawberries >= 46, "fat_constraint3")

m.addConstr(7 * hot_dogs - 6 * strawberries >= 0, "constraint4")
m.addConstr(5 * hot_dogs - 3 * cornichons >= 0, "constraint5")

m.addConstr(22 * hot_dogs + 9 * strawberries <= 127, "protein_constraint5")
m.addConstr(3 * cornichons + 9 * strawberries <= 94, "protein_constraint6")
m.addConstr(22 * hot_dogs + 3 * cornichons + 9 * strawberries <= 116, "protein_constraint7")

m.addConstr(23 * hot_dogs + 19 * cornichons + 7 * strawberries <= 96, "fat_constraint4")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('hot_dogs:', hot_dogs.x)
    print('cornichons:', cornichons.x)
    print('strawberries:', strawberries.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

