
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="hot_dogs")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="cornichons")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="strawberries")

# Objective function
m.setObjective(7*x0 + 6*x1 + 8*x2, GRB.MINIMIZE)

# Constraints
# Protein constraints
m.addConstr(22*x0 + 9*x2 >= 53, "protein_hot_dogs_strawberries")
m.addConstr(3*x1 + 9*x2 >= 34, "protein_cornichons_strawberries")
m.addConstr(22*x0 + 3*x1 >= 35, "protein_hot_dogs_cornichons")
m.addConstr(22*x0 + 3*x1 + 9*x2 >= 35, "protein_all")

# Fat constraints
m.addConstr(23*x0 + 19*x1 >= 26, "fat_hot_dogs_cornichons")
m.addConstr(23*x0 + 7*x2 >= 46, "fat_hot_dogs_strawberries")
m.addConstr(23*x0 + 19*x1 + 7*x2 >= 46, "fat_all")

# Mixed constraints
m.addConstr(7*x0 - 6*x2 >= 0, "mixed_hot_dogs_strawberries")
m.addConstr(5*x0 - 3*x1 >= 0, "mixed_hot_dogs_cornichons")

# Upper bound protein constraints
m.addConstr(22*x0 + 9*x2 <= 127, "upper_protein_hot_dogs_strawberries")
m.addConstr(3*x1 + 9*x2 <= 94, "upper_protein_cornichons_strawberries")
m.addConstr(22*x0 + 3*x1 + 9*x2 <= 116, "upper_protein_all")

# Upper bound fat constraint
m.addConstr(23*x0 + 19*x1 + 7*x2 <= 96, "upper_fat_all")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hot dogs: {x0.x}")
    print(f"Cornichons: {x1.x}")
    print(f"Strawberries: {x2.x}")
else:
    print("No optimal solution found")
