
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
hot_dogs = m.addVar(name="hot_dogs", lb=0)  # Can be fractional
cornichons = m.addVar(name="cornichons", lb=0)  # Can be fractional
strawberries = m.addVar(name="strawberries", lb=0)  # Can be fractional

# Objective function: Minimize 7 * hot dogs + 6 * cornichons + 8 * strawberries
m.setObjective(7 * hot_dogs + 6 * cornichons + 8 * strawberries, gurobi.GRB.MINIMIZE)

# Constraints
# Protein constraints
m.addConstr(22 * hot_dogs + 3 * cornichons + 9 * strawberries >= 35, name="total_protein_min")
m.addConstr(22 * hot_dogs + 9 * strawberries >= 53, name="hot_dogs_strawberries_protein_min")
m.addConstr(3 * cornichons + 9 * strawberries >= 34, name="cornichons_strawberries_protein_min")
m.addConstr(22 * hot_dogs + 3 * cornichons >= 35, name="hot_dogs_cornichons_protein_min")
m.addConstr(22 * hot_dogs + 3 * cornichons + 9 * strawberries >= 35, name="all_protein_min")
m.addConstr(22 * hot_dogs + 3 * cornichons + 9 * strawberries <= 116, name="all_protein_max")
m.addConstr(22 * hot_dogs + 9 * strawberries <= 127, name="hot_dogs_strawberries_protein_max")
m.addConstr(3 * cornichons + 9 * strawberries <= 94, name="cornichons_strawberries_protein_max")

# Fat constraints
m.addConstr(23 * hot_dogs + 19 * cornichons + 7 * strawberries <= 96, name="total_fat_max")
m.addConstr(23 * hot_dogs + 19 * cornichons >= 26, name="hot_dogs_cornichons_fat_min")
m.addConstr(23 * hot_dogs + 7 * strawberries >= 46, name="hot_dogs_strawberries_fat_min")
m.addConstr(23 * hot_dogs + 19 * cornichons + 7 * strawberries >= 46, name="all_fat_min")

# Additional constraints
m.addConstr(7 * hot_dogs - 6 * strawberries >= 0, name="hot_dogs_strawberries_constraint")
m.addConstr(5 * hot_dogs - 3 * cornichons >= 0, name="hot_dogs_cornichons_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hot dogs: {hot_dogs.varValue}")
    print(f"Cornichons: {cornichons.varValue}")
    print(f"Strawberries: {strawberries.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
