
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
b = m.addVar(lb=0, name="strips of bacon")  
h = m.addVar(lb=0, name="hamburgers")  
e = m.addVar(lb=0, name="eggs")  
t = m.addVar(lb=0, name="tomatoes")  
k = m.addVar(lb=0, name="kiwis")  
g = m.addVar(lb=0, name="green beans")  

# Objective function
m.setObjective(4.83*b + 4.13*h + 8.98*e + 8.37*t + 8.57*k + 2.51*g, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(4.54*b + 4.39*g >= 74)
m.addConstr(4.54*b + 6.92*t >= 66)
m.addConstr(5.82*k + 4.39*g >= 57)
m.addConstr(6.92*t + 4.39*g >= 70)
m.addConstr(1.24*h + 5.82*k >= 51)
m.addConstr(4.54*b + 1.24*h + 4.44*e >= 54)
m.addConstr(4.54*b + 4.44*e + 5.82*k >= 54)
m.addConstr(1.24*h + 4.44*e + 5.91*g >= 54)
m.addConstr(4.54*b + 4.44*e + 6.92*t >= 54)
m.addConstr(4.54*b + 6.92*t + 5.82*k >= 54)
m.addConstr(1.24*h + 4.44*e + 5.82*k >= 54)
m.addConstr(4.54*b + 6.92*t + 4.39*g >= 54)
m.addConstr(1.24*h + 6.92*t + 5.82*k >= 54)
m.addConstr(1.24*h + 4.44*e + 6.92*t >= 54)

m.addConstr(3.82*b + 5.91*g >= 22)
m.addConstr(4.72*h + 5.41*t >= 24)
m.addConstr(3.14*e + 5.41*t >= 33)
m.addConstr(5.41*t + 5.91*g >= 23)
m.addConstr(3.82*b + 3.14*e + 3.39*k >= 30)
m.addConstr(3.82*b + 4.72*h + 5.91*g >= 30)
m.addConstr(3.82*b + 3.14*e + 5.91*g >= 30)
m.addConstr(3.82*b + 4.72*h + 3.14*e >= 30)
m.addConstr(4.72*h + 5.41*t + 5.91*g >= 30)
m.addConstr(3.82*b + 5.41*t + 5.91*g >= 30)
m.addConstr(3.14*e + 5.41*t + 5.91*g >= 30)
m.addConstr(3.82*b + 3.14*e + 3.39*k >= 23)
m.addConstr(3.82*b + 4.72*h + 5.91*g >= 23)
m.addConstr(3.82*b + 3.14*e + 5.91*g >= 23)
m.addConstr(3.82*b + 4.72*h + 3.14*e >= 23)
m.addConstr(4.72*h + 5.41*t + 5.91*g >= 23)
m.addConstr(3.82*b + 5.41*t + 5.91*g >= 23)
m.addConstr(3.14*e + 5.41*t + 5.91*g >= 23)
m.addConstr(3.82*b + 3.14*e + 3.39*k >= 38)
m.addConstr(3.82*b + 4.72*h + 5.91*g >= 38)
m.addConstr(3.82*b + 3.14*e + 5.91*g >= 38)
m.addConstr(3.82*b + 4.72*h + 3.14*e >= 38)
m.addConstr(4.72*h + 5.41*t + 5.91*g >= 38)
m.addConstr(3.82*b + 5.41*t + 5.91*g >= 38)
m.addConstr(3.14*e + 5.41*t + 5.91*g >= 38)
m.addConstr(3.82*b + 4.72*h + 3.14*e + 6.92*t + 5.82*k + 4.39*g >= 80)

m.addConstr(7 * e - 9 * k >= 0)
m.addConstr(-7 * b + 10 * k >= 0)
m.addConstr(2 * t - 4 * k >= 0)
m.addConstr(8 * b - 5 * e >= 0)

m.addConstr(4.54*b + 5.82*k <= 202)
m.addConstr(1.24*h + 6.92*t <= 206)
m.addConstr(4.44*e + 5.82*k <= 303)
m.addConstr(1.24*h + 4.44*e <= 510)
m.addConstr(4.54*b + 1.24*h <= 327)
m.addConstr(4.44*e + 4.39*g <= 135)
m.addConstr(4.44*e + 6.92*t <= 270)
m.addConstr(6.92*t + 4.39*g <= 357)
m.addConstr(6.92*t + 5.82*k <= 482)
m.addConstr(4.54*b + 4.44*e <= 450)
m.addConstr(4.54*b + 4.39*g <= 204)
m.addConstr(5.82*k + 4.39*g <= 274)
m.addConstr(4.54*b + 4.44*e + 5.82*k <= 477)
m.addConstr(4.44*e + 5.82*k + 4.39*g <= 203)
m.addConstr(1.24*h + 6.92*t + 5.82*k <= 133)
m.addConstr(4.54*b + 4.44*e + 6.92*t <= 178)
m.addConstr(4.54*b + 6.92*t + 4.39*g <= 109)
m.addConstr(4.54*b + 1.24*h + 6.92*t <= 404)
m.addConstr(4.54*b + 6.92*t + 5.82*k <= 134)
m.addConstr(1.24*h + 6.92*t + 4.39*g <= 417)
m.addConstr(5.82*k + 4.39*g <= 153)
m.addConstr(1.24*h + 4.44*e + 6.92*t <= 120)
m.addConstr(1.24*h + 5.82*k + 4.39*g <= 405)
m.addConstr(4.44*e + 6.92*t + 4.39*g <= 166)
m.addConstr(4.44*e + 6.92*t + 5.82*k <= 223)
m.addConstr(1.24*h + 4.44*e + 4.39*g <= 272)
m.addConstr(5.41*t + 3.39*k <= 173)
m.addConstr(3.82*b + 2.94*e <= 88)
m.addConstr(4.72*h + 5.41*t <= 174)
m.addConstr(4.72*h + 5.91*g <= 235)
m.addConstr(5.41*t + 5.91*g <= 73)
m.addConstr(4.72*h + 2.94*e <= 138)
m.addConstr(3.82*b + 5.41*t <= 89)
m.addConstr(4.72*h + 4.39*g <= 142)
m.addConstr(2.94*e + 4.39*g <= 228)
m.addConstr(3.39*k + 4.39*g <= 61)
m.addConstr(4.72*h + 3.39*k <= 124)
m.addConstr(3.82*b + 5.41*t + 3.39*k <= 104)
m.addConstr(3.82*b + 3.39*k + 4.39*g <= 170)
m.addConstr(3.82*b + 2.94*e + 4.39*g <= 157)
m.addConstr(4.72*h + 2.94*e + 3.39*k <= 153)

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Strips of bacon: ", b.varValue)
    print("Hamburgers: ", h.varValue)
    print("Eggs: ", e.varValue)
    print("Tomatoes: ", t.varValue)
    print("Kiwis: ", k.varValue)
    print("Green beans: ", g.varValue)
else:
    print("No optimal solution found")
