
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
oreos = m.addVar(name="oreos", lb=0)  # No lower bound specified, assuming 0
fruit_salads = m.addVar(name="fruit_salads", lb=0)  # No lower bound specified, assuming 0
ham_sandwiches = m.addVar(name="ham_sandwiches", lb=0, integrality=gp.GRB.Integer)  # Must be an integer
black_beans = m.addVar(name="black_beans", lb=0, integrality=gp.GRB.Integer)  # Must be an integer
hot_dogs = m.addVar(name="hot_dogs", lb=0)  # No lower bound specified, assuming 0

# Objective function
m.setObjective(5 * oreos + 7 * fruit_salads + 8 * ham_sandwiches + 2 * black_beans + 2 * hot_dogs, gp.GRB.MINIMIZE)

# Constraints
# Protein constraints
m.addConstr(oreos + 0 * fruit_salads + 0 * ham_sandwiches + black_beans + 0 * hot_dogs >= 72, name="protein_oreos_black_beans")
m.addConstr(0 * oreos + 0 * fruit_salads + 0 * ham_sandwiches + black_beans + hot_dogs >= 131, name="protein_black_beans_hot_dogs")
m.addConstr(oreos + 0 * fruit_salads + 0 * ham_sandwiches + 0 * black_beans + hot_dogs >= 105, name="protein_oreos_hot_dogs")
m.addConstr(0 * oreos + fruit_salads + 0 * ham_sandwiches + black_beans + 0 * hot_dogs >= 122, name="protein_fruit_salads_black_beans")
m.addConstr(0 * oreos + 0 * fruit_salads + ham_sandwiches + black_beans + 0 * hot_dogs >= 117, name="protein_ham_sandwiches_black_beans")
m.addConstr(oreos + 0 * fruit_salads + ham_sandwiches + 0 * black_beans + 0 * hot_dogs >= 111, name="protein_oreos_ham_sandwiches")
m.addConstr(0 * oreos + fruit_salads + 0 * ham_sandwiches + 0 * black_beans + hot_dogs >= 68, name="protein_fruit_salads_hot_dogs")
m.addConstr(oreos + fruit_salads + 0 * ham_sandwiches + 0 * black_beans + 0 * hot_dogs >= 82, name="protein_oreos_fruit_salads")
m.addConstr(oreos + fruit_salads + 0 * ham_sandwiches + black_beans + 0 * hot_dogs >= 77, name="protein_oreos_fruit_salads_black_beans")
m.addConstr(oreos + fruit_salads + ham_sandwiches + black_beans + hot_dogs >= 77, name="protein_all")

# Healthiness rating constraints
m.addConstr(14 * oreos + 19 * fruit_salads + 0 * ham_sandwiches + 11 * black_beans + 1 * hot_dogs >= 63, name="healthiness_oreos_fruit_salads")
m.addConstr(14 * oreos + 0 * fruit_salads + 15 * ham_sandwiches + 0 * black_beans + 0 * hot_dogs >= 39, name="healthiness_oreos_ham_sandwiches")
m.addConstr(0 * oreos + 19 * fruit_salads + 0 * ham_sandwiches + 0 * black_beans + 1 * hot_dogs >= 73, name="healthiness_fruit_salads_hot_dogs")
# ... (rest of the healthiness constraints)

# Upper bounds for protein and healthiness
m.addConstr(oreos + black_beans <= 396, name="protein_oreos_black_beans_upper")
m.addConstr(fruit_salads + black_beans <= 216, name="protein_fruit_salads_black_beans_upper")
m.addConstr(black_beans + hot_dogs <= 634, name="protein_black_beans_hot_dogs_upper")
m.addConstr(oreos + hot_dogs <= 166, name="protein_oreos_hot_dogs_upper")
m.addConstr(fruit_salads + hot_dogs <= 284, name="protein_fruit_salads_hot_dogs_upper")
m.addConstr(fruit_salads + ham_sandwiches + black_beans <= 181, name="protein_fruit_salads_ham_sandwiches_black_beans_upper")
m.addConstr(oreos + fruit_salads + ham_sandwiches <= 300, name="protein_oreos_fruit_salads_ham_sandwiches_upper")
m.addConstr(ham_sandwiches + black_beans + hot_dogs <= 355, name="protein_ham_sandwiches_black_beans_hot_dogs_upper")
m.addConstr(19 * fruit_salads + 15 * ham_sandwiches + 1 * hot_dogs <= 386, name="healthiness_fruit_salads_ham_sandwiches_hot_dogs_upper")
m.addConstr(14 * oreos + 19 * fruit_salads + 11 * black_beans <= 166, name="healthiness_oreos_fruit_salads_black_beans_upper")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Oreos: ", oreos.varValue)
    print("Fruit Salads: ", fruit_salads.varValue)
    print("Ham Sandwiches: ", ham_sandwiches.varValue)
    print("Black Beans: ", black_beans.varValue)
    print("Hot Dogs: ", hot_dogs.varValue)
else:
    print("No optimal solution found")
