
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
orange_trees = m.addVar(vtype=GRB.INTEGER, name="orange_trees")
zucchini_vines = m.addVar(vtype=GRB.INTEGER, name="zucchini_vines")
agave = m.addVar(vtype=GRB.INTEGER, name="agave")

# Set objective function
m.setObjective(8 * orange_trees**2 + 8 * orange_trees * zucchini_vines + 8 * orange_trees * agave + 2 * zucchini_vines**2 + 7 * zucchini_vines * agave + 3 * agave**2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(23 * orange_trees + 17 * agave >= 61, "c1")
m.addConstr(9**2 * zucchini_vines**2 + 17**2 * agave**2 >= 22, "c2")  # Note: growth speed is squared here
m.addConstr(23 * orange_trees + 9 * zucchini_vines + 17 * agave >= 30, "c3")
m.addConstr(23**2 * orange_trees**2 + 17**2 * agave**2 <= 145, "c4") # Note: growth speed is squared here
m.addConstr(23 * orange_trees + 9 * zucchini_vines + 17 * agave <= 145, "c5")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('orange_trees:', orange_trees.x)
    print('zucchini_vines:', zucchini_vines.x)
    print('agave:', agave.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

