
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="orange_trees")
x1 = m.addVar(vtype=GRB.INTEGER, name="zucchini_vines")
x2 = m.addVar(vtype=GRB.INTEGER, name="agave")

# Objective function: Maximize
m.setObjective(8*x0**2 + 8*x0*x1 + 8*x0*x2 + 2*x1**2 + 7*x1*x2 + 3*x2**2, GRB.MAXIMIZE)

# Constraints
m.addConstr(x0 * 23 >= 61 - 17 * x2, name="orange_and_agave_min")
m.addConstr((x1 * 9)**2 + (x2 * 17)**2 >= 22, name="zucchini_and_agave_squared_min")
m.addConstr(23*x0 + 9*x1 + 17*x2 >= 30, name="total_growth_speed_min")
m.addConstr((x0 * 23)**2 + (x2 * 17)**2 <= 145, name="orange_and_agave_max")
m.addConstr(23*x0 + 9*x1 + 17*x2 <= 145, name="total_growth_speed_max")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Orange Trees: {x0.x}")
    print(f"Zucchini Vines: {x1.x}")
    print(f"Agave: {x2.x}")
else:
    print("No optimal solution found")
