
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    orange_trees = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="orange_trees")
    zucchini_vines = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="zucchini_vines")
    agave = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="agave")

    # Objective function
    model.setObjective(8 * orange_trees**2 + 8 * orange_trees * zucchini_vines + 8 * orange_trees * agave +
                       2 * zucchini_vines**2 + 7 * zucchini_vines * agave + 3 * agave**2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(23 * orange_trees + 17 * agave >= 61, name="growth_speed_orange_agave")
    model.addConstr(9**2 * zucchini_vines**2 + 17**2 * agave**2 >= 22, name="growth_speed_zucchini_agave")
    model.addConstr(23 * orange_trees + 9 * zucchini_vines + 17 * agave >= 30, name="total_growth_speed_min")
    model.addConstr(23**2 * orange_trees**2 + 17**2 * agave**2 <= 145, name="total_growth_speed_orange_agave_max")
    model.addConstr(23 * orange_trees + 9 * zucchini_vines + 17 * agave <= 145, name="total_growth_speed_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Orange Trees: {orange_trees.varValue}")
        print(f"Zucchini Vines: {zucchini_vines.varValue}")
        print(f"Agave: {agave.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
