
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Labor Cost")

# Create variables
john_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="john_hours")
george_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="george_hours")

# Set objective function
model.setObjective(3 * john_hours + 1 * george_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(14 * john_hours + 17 * george_hours >= 39, "productivity_min")
model.addConstr(14 * john_hours + 4 * george_hours >= 21, "computer_competence_min")
model.addConstr(11 * john_hours + 20 * george_hours >= 66, "organization_score_min")
model.addConstr(2 * john_hours - 7 * george_hours >= 0, "custom_constraint")
model.addConstr(14 * john_hours + 17 * george_hours <= 106, "productivity_max")
model.addConstr(14 * john_hours + 4 * george_hours <= 55, "computer_competence_max")
model.addConstr(11 * john_hours + 20 * george_hours <= 131, "organization_score_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found: John's hours = {john_hours.x}, George's hours = {george_hours.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

