
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
hours_worked_by_John = m.addVar(lb=0, name="hours_worked_by_John")
hours_worked_by_George = m.addVar(lb=0, name="hours_worked_by_George")

# Objective function: Minimize 3*hours_worked_by_John + hours_worked_by_George
m.setObjective(3 * hours_worked_by_John + hours_worked_by_George, GRB.MINIMIZE)

# Constraints
# Productivity rating constraint: 14*hours_worked_by_John + 17*hours_worked_by_George >= 39 and <= 106
m.addConstr(14 * hours_worked_by_John + 17 * hours_worked_by_George >= 39, name="productivity_min")
m.addConstr(14 * hours_worked_by_John + 17 * hours_worked_by_George <= 106, name="productivity_max")

# Computer competence rating constraint: 14*hours_worked_by_John + 4*hours_worked_by_George >= 21 and <= 55
m.addConstr(14 * hours_worked_by_John + 4 * hours_worked_by_George >= 21, name="computer_min")
m.addConstr(14 * hours_worked_by_John + 4 * hours_worked_by_George <= 55, name="computer_max")

# Organization score constraint: 11*hours_worked_by_John + 20*hours_worked_by_George >= 66 and <= 131
m.addConstr(11 * hours_worked_by_John + 20 * hours_worked_by_George >= 66, name="organization_min")
m.addConstr(11 * hours_worked_by_John + 20 * hours_worked_by_George <= 131, name="organization_max")

# Linear combination constraint: 2*hours_worked_by_John - 7*hours_worked_by_George >= 0
m.addConstr(2 * hours_worked_by_John - 7 * hours_worked_by_George >= 0, name="linear_combination")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by John: {hours_worked_by_John.x}")
    print(f"Hours worked by George: {hours_worked_by_George.x}")
else:
    print("No optimal solution found.")
