
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    hours_worked_by_John = model.addVar(lb=0, name="hours_worked_by_John")
    hours_worked_by_George = model.addVar(lb=0, name="hours_worked_by_George")

    # Objective function: Minimize 3 * hours_worked_by_John + 1 * hours_worked_by_George
    model.setObjective(3 * hours_worked_by_John + 1 * hours_worked_by_George, gurobi.GRB.MINIMIZE)

    # Constraints
    # Individual ratings (not actually constraints in this case, just data)
    john_productivity_rating = 14
    john_computer_competence_rating = 14
    john_organization_score = 11
    george_productivity_rating = 17
    george_computer_competence_rating = 4
    george_organization_score = 20

    # Combined ratings constraints
    model.addConstr(john_productivity_rating * hours_worked_by_John + george_productivity_rating * hours_worked_by_George >= 39, name="productivity_rating_min")
    model.addConstr(john_productivity_rating * hours_worked_by_John + george_productivity_rating * hours_worked_by_George <= 106, name="productivity_rating_max")

    model.addConstr(john_computer_competence_rating * hours_worked_by_John + george_computer_competence_rating * hours_worked_by_George >= 21, name="computer_competence_rating_min")
    model.addConstr(john_computer_competence_rating * hours_worked_by_John + george_computer_competence_rating * hours_worked_by_George <= 55, name="computer_competence_rating_max")

    model.addConstr(john_organization_score * hours_worked_by_John + george_organization_score * hours_worked_by_George >= 66, name="organization_score_min")
    model.addConstr(john_organization_score * hours_worked_by_John + george_organization_score * hours_worked_by_George <= 131, name="organization_score_max")

    # Additional constraint
    model.addConstr(2 * hours_worked_by_John - 7 * hours_worked_by_George >= 0, name="additional_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Hours worked by John: {hours_worked_by_John.varValue}")
        print(f"Hours worked by George: {hours_worked_by_George.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
