
from gurobipy import *

# Create a new model
m = Model("Nutrient_Optimization")

# Define variables (not restricted to integers)
x0 = m.addVar(lb=0, name="milligrams_of_vitamin_B1")
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B5")
x2 = m.addVar(lb=0, name="grams_of_fat")
x3 = m.addVar(lb=0, name="milligrams_of_vitamin_C")

# Objective function: Maximize
m.setObjective(7.92*x0 + 4.9*x1 + 7.67*x2 + 3.68*x3, GRB.MAXIMIZE)

# Constraints based on the given problem description
# Cognitive performance index constraints (lower bounds)
m.addConstr(5*x0 + 5*x1 + 5*x2 >= 44, name="cognitive_lower_bound_1")
m.addConstr(5*x0 + 5*x1 + 6*x3 >= 44, name="cognitive_lower_bound_2")
m.addConstr(5*x0 + 6*x3 + 5*x2 >= 44, name="cognitive_lower_bound_3")
m.addConstr(5*x1 + 5*x2 + 6*x3 >= 44, name="cognitive_lower_bound_4")

# Upper bounds for cognitive performance index
m.addConstr(5*x0 + 5*x1 + 6*x3 <= 211, name="cognitive_upper_bound_1")
m.addConstr(5*x0 + 5*x1 + 5*x2 <= 238, name="cognitive_upper_bound_2")
m.addConstr(5*x0 + 5*x1 + 5*x2 + 6*x3 <= 238, name="cognitive_total_upper_bound")

# Digestive support index constraints
m.addConstr(8*x0 + 7*x1 + 10*x2 <= 79, name="digestive_support_index")
m.addConstr(8*x0 + 12*x3 <= 79, name="digestive_vitamin_b1_c")
m.addConstr(7*x1 + 10*x2 <= 47, name="digestive_vitamin_b5_fat")

# Cardiovascular support index constraints
m.addConstr(9*x0 + 2*x2 <= 46, name="cardiovascular_vitamin_b1_fat")
m.addConstr(14*x1 + 6*x3 <= 37, name="cardiovascular_vitamin_b5_c")
m.addConstr(9*x0 + 6*x3 <= 31, name="cardiovascular_vitamin_b1_c")

# Energy stability index constraints
m.addConstr(13*x0 + 4*x1 <= 80, name="energy_stability_vitamin_b1_b5")
m.addConstr(13*x0 + 8*x2 + 11*x3 >= 29, name="energy_stability_lower_bound_1")
m.addConstr(13*x0 + 4*x1 + 8*x2 >= 47, name="energy_stability_lower_bound_2")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B1: {x0.x}")
    print(f"Milligrams of Vitamin B5: {x1.x}")
    print(f"Grams of Fat: {x2.x}")
    print(f"Milligrams of Vitamin C: {x3.x}")
else:
    print("No optimal solution found")
