
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_labor_cost")

# Create variables
laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
john_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="john_hours")
george_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george_hours")
hank_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")

# Set objective function
m.setObjective(3.4 * laura_hours + 3.75 * john_hours + 9.58 * george_hours + 9.08 * hank_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * john_hours + 6 * hank_hours >= 45, "c1")
m.addConstr(28 * laura_hours + 8 * john_hours >= 55, "c2")
m.addConstr(28 * laura_hours + 8 * john_hours + 27 * george_hours + 6 * hank_hours >= 55, "c3")
m.addConstr(4 * laura_hours + 2 * john_hours >= 30, "c4")
m.addConstr(4 * laura_hours + 11 * hank_hours >= 44, "c5")
m.addConstr(6 * george_hours + 11 * hank_hours >= 31, "c6")
m.addConstr(4 * laura_hours + 6 * george_hours >= 30, "c7")
m.addConstr(4 * laura_hours + 6 * george_hours + 11 * hank_hours >= 32, "c8")
m.addConstr(4 * laura_hours + 2 * john_hours + 11 * hank_hours >= 32, "c9")
m.addConstr(4 * laura_hours + 6 * george_hours + 11 * hank_hours >= 45, "c10")
m.addConstr(4 * laura_hours + 2 * john_hours + 11 * hank_hours >= 45, "c11")
m.addConstr(4 * laura_hours + 2 * john_hours + 6 * george_hours + 11 * hank_hours >= 45, "c12")
m.addConstr(-10 * laura_hours + 3 * hank_hours >= 0, "c13")
m.addConstr(28 * laura_hours + 6 * hank_hours <= 261, "c14")
m.addConstr(27 * george_hours + 6 * hank_hours <= 273, "c15")
m.addConstr(28 * laura_hours + 8 * john_hours <= 203, "c16")
m.addConstr(2 * john_hours + 6 * george_hours <= 93, "c17")
m.addConstr(4 * laura_hours + 11 * hank_hours <= 103, "c18")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Laura Hours: %g' % laura_hours.x)
    print('John Hours: %g' % john_hours.x)
    print('George Hours: %g' % george_hours.x)
    print('Hank Hours: %g' % hank_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
