
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
l = m.addVar(lb=0, name="hours_worked_by_Laura", vtype=GRB.CONTINUOUS)
j = m.addVar(lb=0, name="hours_worked_by_John", vtype=GRB.INTEGER)
g = m.addVar(lb=0, name="hours_worked_by_George", vtype=GRB.CONTINUOUS)
h = m.addVar(lb=0, name="hours_worked_by_Hank", vtype=GRB.CONTINUOUS)

# Objective function
m.setObjective(3.4*l + 3.75*j + 9.58*g + 9.08*h, GRB.MINIMIZE)

# Constraints
# Dollar cost constraints
m.addConstr(8*j + 6*h >= 45, name="dollar_cost_j_h")
m.addConstr(28*l + 8*j >= 55, name="dollar_cost_l_j")
m.addConstr(28*l + 8*j + 27*g + 6*h >= 55, name="total_dollar_cost")
m.addConstr(28*l + 6*h <= 261, name="max_dollar_cost_l_h")
m.addConstr(27*g + 6*h <= 273, name="max_dollar_cost_g_h")
m.addConstr(28*l + 8*j <= 203, name="max_dollar_cost_l_j")

# Productivity rating constraints
m.addConstr(4*l + 2*j >= 30, name="productivity_l_j")
m.addConstr(4*l + 11*h >= 44, name="productivity_l_h")
m.addConstr(6*g + 11*h >= 31, name="productivity_g_h")
m.addConstr(4*l + 6*g >= 30, name="productivity_l_g")
m.addConstr(4*l + 6*g + 11*h >= 32, name="productivity_l_g_h")
m.addConstr(4*l + 2*j + 11*h >= 32, name="productivity_l_j_h")
m.addConstr(4*l + 6*g + 11*h >= 45, name="total_productivity_l_g_h")
m.addConstr(4*l + 2*j + 11*h >= 45, name="total_productivity_l_j_h")
m.addConstr(4*l + 2*j + 6*g + 11*h >= 45, name="total_productivity_all")
m.addConstr(2*j + 6*g <= 93, name="max_productivity_j_g")
m.addConstr(4*l + 11*h <= 103, name="max_productivity_l_h")

# Additional linear constraints
m.addConstr(-10*l + 3*h >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print the solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
