
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
L = m.addVar(lb=0, name="hours_worked_by_Laura", vtype=gp.GRB.CONTINUOUS)
J = m.addVar(lb=0, name="hours_worked_by_John", vtype=gp.GRB.INTEGER)
G = m.addVar(lb=0, name="hours_worked_by_George", vtype=gp.GRB.CONTINUOUS)
H = m.addVar(lb=0, name="hours_worked_by_Hank", vtype=gp.GRB.CONTINUOUS)

# Objective function
m.setObjective(3.4*L + 3.75*J + 9.58*G + 9.08*H, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(8*J + 6*H >= 45, name="constraint_1")
m.addConstr(28*L + 8*J >= 55, name="constraint_2")
m.addConstr(28*L + 8*J + 27*G + 6*H >= 55, name="constraint_3")
m.addConstr(4*L + 2*J >= 30, name="constraint_4")
m.addConstr(4*L + 11*H >= 44, name="constraint_5")
m.addConstr(6*G + 11*H >= 31, name="constraint_6")
m.addConstr(4*L + 6*G >= 30, name="constraint_7")
m.addConstr(4*L + 6*G + 11*H >= 32, name="constraint_8")
m.addConstr(4*L + 2*J + 11*H >= 32, name="constraint_9")
m.addConstr(4*L + 6*G + 11*H >= 45, name="constraint_10")
m.addConstr(4*L + 2*J + 11*H >= 45, name="constraint_11")
m.addConstr(4*L + 2*J + 6*G + 11*H >= 45, name="constraint_12")
m.addConstr(-10*L + 3*H >= 0, name="constraint_13")
m.addConstr(28*L + 6*H <= 261, name="constraint_14")
m.addConstr(27*G + 6*H <= 273, name="constraint_15")
m.addConstr(28*L + 8*J <= 203, name="constraint_16")
m.addConstr(2*J + 6*G <= 93, name="constraint_17")
m.addConstr(4*L + 11*H <= 103, name="constraint_18")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Laura: {L.varValue}")
    print(f"Hours worked by John: {J.varValue}")
    print(f"Hours worked by George: {G.varValue}")
    print(f"Hours worked by Hank: {H.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
