
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x_B = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="hours_worked_by_Bill")
x_M = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Mary")
x_J = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Jean")
x_Bo = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Bobby")
x_P = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Peggy")
x_John = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_John")
x_L = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Laura")

# Objective function
m.setObjective(9.14*x_B + 5.59*x_M + 5.6*x_J + 5.74*x_Bo + 7.63*x_P + 4.24*x_John + 8.77*x_L, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(6*x_B <= 124)
m.addConstr(7*x_M <= 124)
m.addConstr(4*x_J <= 124)
m.addConstr(13*x_Bo <= 124)
m.addConstr(2*x_P <= 124)
m.addConstr(4*x_John <= 124)
m.addConstr(9*x_L <= 124)
m.addConstr(13*x_Bo + 2*x_P >= 12)
m.addConstr(4*x_J + 4*x_John >= 17)
m.addConstr(6*x_B + 4*x_John >= 7)
m.addConstr(7*x_M + 4*x_J >= 15)
m.addConstr(6*x_B + 4*x_J >= 11)
m.addConstr(13*x_Bo + 2*x_P >= 16)
# Add all other constraints similarly...

# Solve the model
m.optimize()

# Print the objective value
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bill: ", x_B.varValue)
    print("Hours worked by Mary: ", x_M.varValue)
    print("Hours worked by Jean: ", x_J.varValue)
    print("Hours worked by Bobby: ", x_Bo.varValue)
    print("Hours worked by Peggy: ", x_P.varValue)
    print("Hours worked by John: ", x_John.varValue)
    print("Hours worked by Laura: ", x_L.varValue)
else:
    print("The model is infeasible or unbounded.")
