
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("minimize_work_hours")

# Create variables
john = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="John")
dale = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Dale")
laura = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Laura")
paul = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Paul")
george = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="George")
bill = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bill")

# Set objective function
m.setObjective(6*john*john + 3*john*paul + john*bill + 7*dale*george + 2*laura*paul + 6*laura*bill + 3*paul*paul + 2*paul*bill + 6*george*george + 5*george, GRB.MINIMIZE)

# Add constraints
m.addConstr(9*john*john + 5*dale*dale >= 32)
m.addConstr(5*laura + 4*george >= 19)
m.addConstr(5*dale + 4*paul >= 29)
m.addConstr(9*john + 10*bill >= 48)
m.addConstr(9*john + 4*paul >= 43)
m.addConstr(4*paul + 4*george >= 37)
m.addConstr(4*paul + 10*bill >= 17)
m.addConstr(5*laura*laura + 10*bill*bill >= 35)
m.addConstr(5*dale + 10*bill >= 20)
m.addConstr(5*dale + 5*laura >= 41)
m.addConstr(4*george + 10*bill >= 45)
m.addConstr(5*laura + 4*george + 10*bill >= 43)
m.addConstr(9*john*john + 5*dale*dale + 10*bill*bill >= 43)
m.addConstr(5*dale + 5*laura + 4*paul >= 43)
m.addConstr(5*dale + 4*paul + 4*george >= 43)
m.addConstr(9*john + 5*laura + 4*george >= 43)
m.addConstr(5*laura + 4*paul + 10*bill >= 43)
m.addConstr(9*john + 5*dale + 4*george >= 43)
m.addConstr(9*john*john + 4*paul*paul + 10*bill*bill >= 43)
m.addConstr(4*paul*paul + 4*george*george + 10*bill*bill >= 43)
m.addConstr(5*laura + 4*paul + 4*george >= 43)
m.addConstr(9*john + 5*dale + 4*paul >= 43)
m.addConstr(5*dale + 4*george + 10*bill >= 43)
m.addConstr(9*john + 4*george + 10*bill >= 43)
m.addConstr(5*dale + 5*laura + 10*bill >= 43)

# ... (The rest of the dollar cost per hour constraints)

m.addConstr(3*dale + 6*george >= 42)
m.addConstr(6*john + 6*paul >= 31)
m.addConstr(6*john + 7*bill >= 25)
m.addConstr(8*laura + 7*bill >= 24)
m.addConstr(6*john + 3*dale + 8*laura + 6*paul + 6*george + 7*bill >= 24)

# ... (The rest of the work quality, computer competence, and organization score constraints)

m.addConstr(9*john - 4*laura >= 0)
m.addConstr(5*laura*laura - george*george - 8*bill*bill >= 0)

# ... (The rest of the upper bound constraints)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
