
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
J = m.addVar(lb=0, name="hours_worked_by_John", vtype=gp.GRB.CONTINUOUS)
D = m.addVar(lb=0, name="hours_worked_by_Dale", vtype=gp.GRB.CONTINUOUS)
L = m.addVar(lb=0, name="hours_worked_by_Laura", vtype=gp.GRB.CONTINUOUS)
P = m.addVar(lb=0, name="hours_worked_by_Paul", vtype=gp.GRB.CONTINUOUS)
G = m.addVar(lb=0, name="hours_worked_by_George", vtype=gp.GRB.CONTINUOUS)
B = m.addVar(lb=0, name="hours_worked_by_Bill", vtype=gp.GRB.CONTINUOUS)

# Objective function
m.setObjective(6*J**2 + 3*J*P + J*B + 7*D*G + 2*L*P + 6*L*B + 3*P**2 + 2*P*B + 6*G**2 + 5*G, gp.GRB.MINIMIZE)

# Constraints
r0 = { 'description': 'dollar cost per hour', 'upper_bound': 302, 'x0': 9, 'x1': 5, 'x2': 5, 'x3': 4, 'x4': 4, 'x5': 10}
r1 = { 'description': 'work quality rating', 'upper_bound': 294, 'x0': 6, 'x1': 3, 'x2': 8, 'x3': 6, 'x4': 6, 'x5': 7}
r2 = { 'description': 'computer competence rating', 'upper_bound': 173, 'x0': 7, 'x1': 6, 'x2': 6, 'x3': 8, 'x4': 3, 'x5': 11}
r3 = { 'description': 'organization score', 'upper_bound': 387, 'x0': 8, 'x1': 11, 'x2': 4, 'x3': 7, 'x4': 11, 'x5': 4}

m.addConstr(J * r0['x0'] <= r0['upper_bound'], "r0_John")
m.addConstr(D * r0['x1'] <= r0['upper_bound'], "r0_Dale")
m.addConstr(L * r0['x2'] <= r0['upper_bound'], "r0_Laura")
m.addConstr(P * r0['x3'] <= r0['upper_bound'], "r0_Paul")
m.addConstr(G * r0['x4'] <= r0['upper_bound'], "r0_George")
m.addConstr(B * r0['x5'] <= r0['upper_bound'], "r0_Bill")

m.addConstr(J * r1['x0'] <= r1['upper_bound'], "r1_John")
m.addConstr(D * r1['x1'] <= r1['upper_bound'], "r1_Dale")
m.addConstr(L * r1['x2'] <= r1['upper_bound'], "r1_Laura")
m.addConstr(P * r1['x3'] <= r1['upper_bound'], "r1_Paul")
m.addConstr(G * r1['x4'] <= r1['upper_bound'], "r1_George")
m.addConstr(B * r1['x5'] <= r1['upper_bound'], "r1_Bill")

m.addConstr(J * r2['x0'] <= r2['upper_bound'], "r2_John")
m.addConstr(D * r2['x1'] <= r2['upper_bound'], "r2_Dale")
m.addConstr(L * r2['x2'] <= r2['upper_bound'], "r2_Laura")
m.addConstr(P * r2['x3'] <= r2['upper_bound'], "r2_Paul")
m.addConstr(G * r2['x4'] <= r2['upper_bound'], "r2_George")
m.addConstr(B * r2['x5'] <= r2['upper_bound'], "r2_Bill")

m.addConstr(J * r3['x0'] <= r3['upper_bound'], "r3_John")
m.addConstr(D * r3['x1'] <= r3['upper_bound'], "r3_Dale")
m.addConstr(L * r3['x2'] <= r3['upper_bound'], "r3_Laura")
m.addConstr(P * r3['x3'] <= r3['upper_bound'], "r3_Paul")
m.addConstr(G * r3['x4'] <= r3['upper_bound'], "r3_George")
m.addConstr(B * r3['x5'] <= r3['upper_bound'], "r3_Bill")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by John: ", J.varValue)
    print("Hours worked by Dale: ", D.varValue)
    print("Hours worked by Laura: ", L.varValue)
    print("Hours worked by Paul: ", P.varValue)
    print("Hours worked by George: ", G.varValue)
    print("Hours worked by Bill: ", B.varValue)
else:
    print("No optimal solution found")
