
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
rotisserie_chickens = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rotisserie_chickens")
cornichons = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cornichons")
ravioli = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ravioli")
pickles = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")

# Set objective function
model.setObjective(8 * rotisserie_chickens + 3 * cornichons + 1 * ravioli + 9 * pickles, GRB.MINIMIZE)

# Add constraints
model.addConstr(8 * rotisserie_chickens + 3 * pickles >= 35, "protein_constraint1")
model.addConstr(8 * rotisserie_chickens + 17 * ravioli >= 35, "protein_constraint2")
model.addConstr(12 * cornichons + 17 * ravioli >= 28, "protein_constraint3")
model.addConstr(12 * cornichons + 3 * pickles >= 18, "protein_constraint4")
model.addConstr(8 * rotisserie_chickens + 12 * cornichons + 17 * ravioli + 3 * pickles >= 18, "protein_constraint5")

model.addConstr(17 * ravioli + 12 * pickles >= 40, "tastiness_constraint1")
model.addConstr(5 * rotisserie_chickens + 17 * ravioli >= 44, "tastiness_constraint2")
model.addConstr(5 * rotisserie_chickens + 17 * ravioli + 12 * pickles >= 52, "tastiness_constraint3")
model.addConstr(5 * rotisserie_chickens + 3 * cornichons + 12 * pickles >= 52, "tastiness_constraint4")
model.addConstr(3 * cornichons + 17 * ravioli + 12 * pickles >= 52, "tastiness_constraint5")
model.addConstr(5 * rotisserie_chickens + 17 * ravioli + 12 * pickles >= 51, "tastiness_constraint6")
model.addConstr(5 * rotisserie_chickens + 3 * cornichons + 12 * pickles >= 51, "tastiness_constraint7")
model.addConstr(3 * cornichons + 17 * ravioli + 12 * pickles >= 51, "tastiness_constraint8")
model.addConstr(5 * rotisserie_chickens + 17 * ravioli + 12 * pickles >= 49, "tastiness_constraint9")
model.addConstr(5 * rotisserie_chickens + 3 * cornichons + 12 * pickles >= 49, "tastiness_constraint10")
model.addConstr(3 * cornichons + 17 * ravioli + 12 * pickles >= 49, "tastiness_constraint11")
model.addConstr(5 * rotisserie_chickens + 3 * cornichons + 17 * ravioli + 12 * pickles >= 49, "tastiness_constraint12")


model.addConstr(10 * cornichons - 8 * ravioli >= 0, "constraint1")
model.addConstr(1 * cornichons - 3 * pickles >= 0, "constraint2")
model.addConstr(-8 * rotisserie_chickens + 9 * ravioli >= 0, "constraint3")

model.addConstr(8 * rotisserie_chickens + 12 * cornichons + 3 * pickles <= 99, "protein_upper_bound1")
model.addConstr(8 * rotisserie_chickens + 17 * ravioli + 3 * pickles <= 130, "protein_upper_bound2")
model.addConstr(12 * cornichons + 17 * ravioli + 3 * pickles <= 52, "protein_upper_bound3")
model.addConstr(5 * rotisserie_chickens + 3 * cornichons + 12 * pickles <= 176, "tastiness_upper_bound1")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

