
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
squash_plants = m.addVar(vtype=gp.GRB.INTEGER, name="squash_plants")
chives = m.addVar(vtype=gp.GRB.INTEGER, name="chives")
orange_trees = m.addVar(vtype=gp.GRB.INTEGER, name="orange_trees")

# Set objective function
m.setObjective(7 * squash_plants**2 + 9 * squash_plants * chives + 2 * orange_trees**2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(23 * squash_plants + 16 * chives >= 129, "c1")
m.addConstr(23**2 * squash_plants**2 + 13**2 * orange_trees**2 >= 84, "c2") # Note: Beauty rating is squared here.
m.addConstr(23 * squash_plants + 16 * chives + 13 * orange_trees >= 84, "c3")
m.addConstr(9 * chives - 3 * orange_trees >= 0, "c4")
m.addConstr(5 * squash_plants - 7 * orange_trees >= 0, "c5")
m.addConstr(23 * squash_plants + 16 * chives <= 314, "c6")
m.addConstr(23 * squash_plants + 16 * chives + 13 * orange_trees <= 463, "c7") # Added upper bound constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('squash_plants:', squash_plants.x)
    print('chives:', chives.x)
    print('orange_trees:', orange_trees.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

