
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the variables
squash_plants = m.addVar(vtype=GRB.INTEGER, name="squash_plants")
chives = m.addVar(vtype=GRB.INTEGER, name="chives")
orange_trees = m.addVar(vtype=GRB.INTEGER, name="orange_trees")

# Objective function: Minimize
m.setObjective(7 * squash_plants**2 + 9 * squash_plants * chives + 2 * orange_trees**2, GRB.MINIMIZE)

# Constraints
# 1. Total combined beauty rating from squash plants and chives should be at minimum 129.
m.addConstr(23*squash_plants + 16*chives >= 129, "beauty_min_1")

# 2. Total combined beauty rating from squash plants squared and orange trees squared should be at minimum 84.
m.addConstr((23*squash_plants)**2 + (13*orange_trees)**2 >= 84, "beauty_min_2")

# 3. Total combined beauty rating from all three must be equal to or greater than 84.
m.addConstr(23*squash_plants + 16*chives + 13*orange_trees >= 84, "total_beauty_min")

# 4. Linear inequality: 9 times the number of chives minus 3 times the number of orange trees must be no less than zero.
m.addConstr(9*chives - 3*orange_trees >= 0, "inequality_1")

# 5. Linear inequality: 5 times the number of squash plants minus 7 times the number of orange trees must be greater than or equal to zero.
m.addConstr(5*squash_plants - 7*orange_trees >= 0, "inequality_2")

# 6. Total combined beauty rating from squash plants plus chives has to be 314 or less.
m.addConstr(23*squash_plants + 16*chives <= 314, "beauty_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Squash Plants: {squash_plants.x}")
    print(f"Chives: {chives.x}")
    print(f"Orange Trees: {orange_trees.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
